using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static int N, M;
    static List<int>[] G;
    static int[] K;

    static void Main()
    {
        int T = int.Parse(Console.ReadLine());
        for(int t=0; t<T; t++)
        {
            var nm = Console.ReadLine().Split().Select(int.Parse).ToArray();
            N = nm[0];
            M = nm[1];
            
            K = Console.ReadLine().Split().Select(int.Parse).ToArray();

            G = new List<int>[N];
            for(int i=0;i<N;i++) G[i] = new List<int>();

            for(int i=0;i<M;i++)
            {
                var ab = Console.ReadLine().Split().Select(int.Parse).ToArray();
                int u = ab[0], v = ab[1];
                G[u].Add(v);
            }

            Console.WriteLine(MaxSinkSCC());
        }
    }

    static int MaxSinkSCC()
    {
        // 1. Tarjan za SCC
        int index = 0;
        int[] indices = new int[N];
        int[] lowlink = new int[N];
        bool[] onStack = new bool[N];
        Stack<int> stack = new Stack<int>();
        int[] compId = new int[N];
        for(int i=0;i<N;i++) { indices[i] = -1; compId[i] = -1; }
        int compCount = 0;

        void StrongConnect(int v)
        {
            indices[v] = index;
            lowlink[v] = index++;
            stack.Push(v);
            onStack[v] = true;

            foreach(var w in G[v])
            {
                if(indices[w]==-1)
                {
                    StrongConnect(w);
                    lowlink[v] = Math.Min(lowlink[v], lowlink[w]);
                }
                else if(onStack[w])
                {
                    lowlink[v] = Math.Min(lowlink[v], indices[w]);
                }
            }

            if(lowlink[v]==indices[v])
            {
                int w;
                do
                {
                    w = stack.Pop();
                    onStack[w] = false;
                    compId[w] = compCount;
                } while(w!=v);
                compCount++;
            }
        }

        for(int v=0;v<N;v++)
            if(indices[v]==-1) StrongConnect(v);

        // 2. ????????? ???? ?? SCC
        long[] compSum = new long[compCount];
        for(int i=0;i<N;i++) compSum[compId[i]] += K[i];

        // 3. ?????? ?????? SCC
        bool[] hasOut = new bool[compCount];
        for(int u=0;u<N;u++)
        {
            foreach(var v in G[u])
            {
                if(compId[u]!=compId[v])
                    hasOut[compId[u]] = true;
            }
        }

        long ans = long.MinValue;
        for(int i=0;i<compCount;i++)
            if(!hasOut[i] && compSum[i]>0)
                ans = Math.Max(ans, compSum[i]);

        return ans==long.MinValue?-1:(int)ans;
    }
}