#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<vector<int>> g(N + 1);
    vector<pair<int,int>> edges;

    for (int i = 0; i < M; i++) {
        int a, b;
        cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
        edges.push_back({a, b});
    }

    vector<int> team(N + 1, 0);

    bool improved = true;
    while (improved) {
        improved = false;
        for (int v = 1; v <= N; v++) {
            int gain = 0;
            for (int u : g[v]) {
                if (team[v] == team[u]) gain++;
                else gain--;
            }
            if (gain > 0) {
                team[v] ^= 1;
                improved = true;
            }
        }
    }

    int satisfied = 0;
    for (auto [a, b] : edges) {
        if (team[a] != team[b]) satisfied++;
    }

    if (satisfied < M / 2) {
        cout << -1;
        return 0;
    }

    vector<int> A, B;
    for (int i = 1; i <= N; i++) {
        if (team[i] == 0) A.push_back(i);
        else B.push_back(i);
    }

    cout << A.size() << " " << B.size() << "\n";
    for (int x : A) cout << x << " ";
    cout << "\n";
    for (int x : B) cout << x << " ";
    cout << "\n";

    return 0;
}