#include <iostream>
#include <vector>
#include <numeric>
#include <algorithm>
using namespace std;
struct Rezultat
{
    long long zbir;
    long long max;
};
Rezultat dfs(int u, const vector<long long>& K,const vector<vector<int>>& grane)
{
    long long tr = K[u];
    long long zbirDece = 0;
    for (int v : grane[u])
    {
        Rezultat dete = dfs(v, K, grane);
        tr += dete.zbir;
        zbirDece += dete.max;
    }
    return { tr, max(tr, zbirDece) };
}
void resi() 
{
    int n, m;
    cin >> n >> m;
    vector<long long> K(n,0);
    vector<vector<int>> grane(n, vector<int>());
    vector<bool> imaRoditelja(n, false);
    for (int i = 0; i < n; i++) 
        cin >> K[i];
    for (int i = 0; i < m; i++) 
    {
        int u, v;
        cin >> u >> v;
        grane[u].push_back(v);
        imaRoditelja[v] = true;
    }
    long long max = 0;
    for (int i = 0; i < n; i++)
    {
        if (!imaRoditelja[i])
        {
            Rezultat r = dfs(i,K,grane);
            max += r.max;
        }
    }
    if (max > 0)
    {
        cout << max << "\n";
    }
    else
    {
        cout << -1 << "\n";
    }
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t;
    cin >> t;
    while (t > 0)
    {
        t--;
        resi();
    }
    return 0;
}