#include <iostream>
#include <vector>
#include <queue>
#include <cmath>

using namespace std;

struct Veza {
    int u, v;
};

void oboji_graf(int N, const vector<vector<int>>& lista_suseda, vector<int>& boja) {
    for (int i = 1; i <= N; ++i) {
        if (boja[i] == 0) {
            queue<int> red;
            red.push(i);
            boja[i] = 1;

            while (!red.empty()) {
                int u = red.front();
                red.pop();

                int sledeca_boja = (boja[u] == 1) ? 2 : 1;

                for (int v : lista_suseda[u]) {
                    if (boja[v] == 0) {
                        boja[v] = sledeca_boja;
                        red.push(v);
                    }
                }
            }
        }
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int N, M;
    if (!(cin >> N >> M)) return 0;

    vector<vector<int>> lista_suseda(N + 1);
    vector<Veza> veze(M);

    for (int i = 0; i < M; ++i) {
        cin >> veze[i].u >> veze[i].v;
        lista_suseda[veze[i].u].push_back(veze[i].v);
        lista_suseda[veze[i].v].push_back(veze[i].u);
    }

    vector<int> boja(N + 1, 0);
    oboji_graf(N, lista_suseda, boja);

    vector<int> tim1_A, tim2_A;
    for (int i = 1; i <= N; ++i) {
        if (boja[i] == 1) {
            tim1_A.push_back(i);
        } else {
            tim2_A.push_back(i);
        }
    }

    long long ispunjeno_A = 0;
    for (const auto& veza : veze) {
        bool u_u_T1 = (boja[veza.u] == 1);
        bool v_u_T1 = (boja[veza.v] == 1);

        if (u_u_T1 != v_u_T1) {
            ispunjeno_A++;
        }
    }

    long long potrebno_ispuniti = floor(M / 2.0);

    vector<int> konacni_T1, konacni_T2;

    if (ispunjeno_A >= potrebno_ispuniti) {
        konacni_T1 = tim1_A;
        konacni_T2 = tim2_A;
    } else {
        konacni_T1 = tim2_A;
        konacni_T2 = tim1_A;
    }
    
    cout << konacni_T1.size() << " " << konacni_T2.size() << endl;
    
    for (int i = 0; i < konacni_T1.size(); ++i) {
        cout << konacni_T1[i] << (i == konacni_T1.size() - 1 ? "" : " ");
    }
    cout << endl;

    for (int i = 0; i < konacni_T2.size(); ++i) {
        cout << konacni_T2[i] << (i == konacni_T2.size() - 1 ? "" : " ");
    }
    cout << endl;

    return 0;
}