#include <iostream>
#include <vector>
using namespace std;

int main() {
    

    int N, M;
    if (!(cin >> N >> M)) return 0;

    vector<vector<int>> adj(N + 1);
    vector<pair<int, int>> edges;
    edges.reserve(M);

    for (int i = 0; i < M; ++i) {
        int A, B;
        cin >> A >> B;
        if (A == B) continue; // ??????? ?? ??????
        adj[A].push_back(B);
        adj[B].push_back(A);
        edges.push_back({ A,B });
    }
    M = (int)edges.size();

    // ?????????? ??????
    if (M == 0) {
        // ???? ????? ?????? ????
        cout << N << " " << 0 << "\n";
        for (int i = 1; i <= N; ++i) cout << i << (i == N ? '\n' : ' ');
        cout << "\n";
        return 0;
    }

    vector<int> side(N + 1, 0);       // 0 ??? 1 – ??? ???? ???????
    vector<int> good(N + 1, 0), bad(N + 1, 0);

    // ??????????: ??? ? ???? 0 ? ??? ????? ?? "????"
    for (int v = 1; v <= N; ++v) {
        bad[v] = (int)adj[v].size();
    }
    long long satisfied = 0; // ???? ????????? ???? (?????? ?????)

    bool changed = true;
    while (changed) {
        changed = false;
        for (int v = 1; v <= N; ++v) {
            if (bad[v] > good[v]) {
                // flip v
                changed = true;
                // ?????? ?? ???????? ???? ?????? ??????
                satisfied += (bad[v] - good[v]);

                side[v] ^= 1; // ??????? ????

                // ???????? ??????
                for (int u : adj[v]) {
                    if (side[u] == side[v]) {
                        // ???? ?? ? ????? ???? ? ????? ?? ????
                        good[u]--;
                        bad[u]++;
                    }
                    else {
                        // ???? ?? ? ?????????? ???????? ? ????? ?? ?????
                        good[u]++;
                        bad[u]--;
                    }
                }
                // ??? v ?? good ? bad ???? ?????? ?????
                swap(good[v], bad[v]);
            }
        }
    }

    // ?? ???????, satisfied >= M/2, ?? ?????? ???? ???????
    // (?? ?????? ????? ?? ???????? -1)
    if (satisfied < M / 2) {
        // ?? ????? ??????, ???? ? ?????? ?? ?? ??????? ?? ?? ????
        cout << -1 << "\n";
        return 0;
    }

    vector<int> team0, team1;
    for (int v = 1; v <= N; ++v) {
        if (side[v] == 0) team0.push_back(v);
        else team1.push_back(v);
    }

    cout << (int)team0.size() << " " << (int)team1.size() << "\n";
    for (int i = 0; i < (int)team0.size(); ++i) {
        cout << team0[i] << (i + 1 == (int)team0.size() ? '\n' : ' ');
    }
    for (int i = 0; i < (int)team1.size(); ++i) {
        cout << team1[i] << (i + 1 == (int)team1.size() ? '\n' : ' ');
    }
}