#include <bits/stdc++.h>
using namespace std;
int main() 
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N, M;
    cin >> N >> M;
    vector<vector<int>> adj(N);
    for (int i = 0; i < M; i++) {
        int a, b;
        cin >> a >> b;
        --a; --b;
        adj[a].push_back(b);
        adj[b].push_back(a);
    }
    vector<int> side(N);
    for (int i = 0; i < N; i++)
        side[i] = i & 1;
    while (true) {
        vector<int> same(N, 0), other(N, 0);
        for (int u = 0; u < N; u++) {
            for (int v : adj[u]) {
                if (side[u] == side[v]) same[u]++;
                else other[u]++;
            }
        }
        int best = -1;
        int bestGain = 0;
        for (int u = 0; u < N; u++) 
            {
            int gain = same[u] - other[u];
            if (gain > bestGain) {
                bestGain = gain;
                best = u;
            }
        }
        if (bestGain <= 0) break;
        side[best] ^= 1;
    }
    long long cut = 0;
    for (int u = 0; u < N; u++) 
        {
        for (int v : adj[u]) 
        {
            if (u < v && side[u] != side[v])
                cut++;
        }
    }
    if (cut < M / 2) 
        {
        cout<<-1<<"\n";
        return 0;
    }
    vector<int> A, B;
    for (int i = 0; i < N; i++) 
    {
        if (side[i] == 0) A.push_back(i + 1);
        else B.push_back(i + 1);
    }
    cout << A.size() << " " << B.size() << "\n";
    for(int x : A) cout << x << " ";
    cout<<"\n";
    for(int x : B) cout<<x<<" ";
    cout<<"\n";
    return 0;
}