#include <bits/stdc++.h>
using namespace std;
void dfs1(int u, vector<vector<int>>& adj, vector<bool>& visited, stack<int>& st) {
    visited[u] = true;
    for (int v : adj[u])
        if (!visited[v]) dfs1(v, adj, visited, st);
    st.push(u);
}
void dfs2(int u, vector<vector<int>>& rev, vector<int>& comp, int id) {
    comp[u] = id;
    for (int v : rev[u])
        if (comp[v] == -1) dfs2(v, rev, comp, id);
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T, i;
    cin>>T;
    while (T--) 
    {
        int N, M;
        cin>>N>>M;
        vector<long long> K(N);
        for (i=0;i<N;++i) cin >> K[i];
        vector<vector<int>> adj(N), rev(N);
        for (i=0;i<M;++i) 
        {
            int u, v;
            cin >> u >> v;
            adj[u].push_back(v);
            rev[v].push_back(u);
        }
        stack<int> st;
        vector<bool> visited(N, false);
        for (i=0;i<N;++i)
            if (!visited[i]) dfs1(i, adj, visited, st);
        vector<int> comp(N, -1);
        int scc_count = 0;
        while (!st.empty()) 
        {
            int u = st.top(); st.pop();
            if (comp[u] == -1) dfs2(u, rev, comp, scc_count++);
        }
        vector<long long> scc_sum(scc_count, 0);
        for (i = 0; i < N; ++i) scc_sum[comp[i]] += K[i];
        vector<vector<int>> dag(scc_count);
        vector<int> outdeg(scc_count, 0);
        for (int u = 0; u < N; ++u) 
        {
            for (int v : adj[u]) 
            {
                int cu = comp[u], cv = comp[v];
                if (cu != cv) 
                {
                    dag[cu].push_back(cv);
                    outdeg[cu]++;
                }
            }
        }
        vector<long long> dp(scc_count, LLONG_MIN);
        queue<int> q;
        for (int i = 0; i < scc_count; ++i)
            if (outdeg[i] == 0) 
            {
                dp[i] = scc_sum[i];
                q.push(i);
            }
        vector<vector<int>> rev_dag(scc_count);
        for (int u = 0; u < scc_count; ++u)
            for (int v : dag[u]) rev_dag[v].push_back(u);
        while (!q.empty()) 
            {
            int u = q.front(); q.pop();
            for (int v : rev_dag[u]) 
            {
                if (dp[v] < dp[u] + scc_sum[v]) 
                    {
                    dp[v] = dp[u] + scc_sum[v];
                    q.push(v);
                }
            }
        }
        long long ans = LLONG_MIN;
        for (int i = 0; i < scc_count; ++i) ans=max(ans, dp[i]);
        if (ans<=0) cout<<-1<<endl;
        else cout<<ans<<endl;
    }
    return 0;
}