#include <bits/stdc++.h>
using namespace std;

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--)
    {
        int n, m;
        cin >> n >> m;

        vector<long long> weights(n);
        for (int i = 0; i < n; i++)
            cin >> weights[i];

        vector<pair<int, int>> edges(m);
        for (int i = 0; i < m; i++)
        {
            cin >> edges[i].first >> edges[i].second;
        }

        vector<vector<int>> graph(n);
        for (int i = 0; i < m; i++)
            graph[edges[i].first].push_back(edges[i].second);

        vector<bool> isTerminal(n);
        for (int i = 0; i < n; i++)
            isTerminal[i] = graph[i].empty();

        vector<long long> dp(n, LLONG_MIN);
        vector<bool> visited(n, false);
        vector<bool> reachable(n, false);

        function<long long(int)> DFS = [&](int u) -> long long
        {
            if (visited[u])
                return dp[u];

            visited[u] = true;

            if (isTerminal[u])
            {
                dp[u] = weights[u];
                reachable[u] = true;
                return dp[u];
            }

            long long best = LLONG_MIN;
            bool canReach = false;

            for (int v : graph[u])
            {
                long long res = DFS(v);
                if (reachable[v])
                {
                    canReach = true;
                    best = max(best, res);
                }
            }

            if (canReach)
            {
                dp[u] = weights[u] + best;
                reachable[u] = true;
            }
            else
            {
                dp[u] = LLONG_MIN;
                reachable[u] = false;
            }

            return dp[u];
        };

        long long answer = LLONG_MIN;
        for (int i = 0; i < n; i++)
        {
            long long val = DFS(i);
            if (reachable[i])
                answer = max(answer, val);
        }

        cout << (answer > 0 ? answer : -1) << '\n';
    }

    return 0;
}