using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

public class Resenje
{
    private static List<int>[] adj;
    private static int[] boja; 

    public class Komponenta
    {
        public List<int> S1 { get; set; } 
        public List<int> S2 { get; set; } 
        public long Ispunjenost1 { get; set; } 
        public long Ispunjenost2 { get; set; } 

        public Komponenta()
        {
            S1 = new List<int>();
            S2 = new List<int>();
        }
    }

    private static (long ispunjeno1, long ispunjeno2) BFS_Coloring(int startNode, int N, List<int>[] adj, out List<int> componentNodes)
    {
        Queue<int> queue = new Queue<int>();
        queue.Enqueue(startNode);
        boja[startNode] = 1; 

        long totalEdges = 0;  
        long neispunjeno1 = 0; 
        long neispunjeno2 = 0; 
        
        List<int> currentComponentNodes = new List<int>();
        
        Queue<int> q_bfs = new Queue<int>();
        q_bfs.Enqueue(startNode);
        currentComponentNodes.Add(startNode);

        while (q_bfs.Count > 0)
        {
            int u = q_bfs.Dequeue();

            foreach (int v in adj[u])
            {
                if (u < v) totalEdges++; 

                if (boja[v] == 0)
                {
                    boja[v] = 3 - boja[u]; 
                    q_bfs.Enqueue(v);
                    currentComponentNodes.Add(v);
                }
            }
        }
        
        foreach (int u in currentComponentNodes)
        {
             foreach (int v in adj[u])
             {
                 if (u < v)
                 {
                    if (boja[u] == boja[v])
                    {
                        if (boja[u] == 1)
                        {
                            neispunjeno1++;
                        }
                        else 
                        {
                            neispunjeno2++;
                        }
                    }
                 }
             }
        }

        long ispunjenoPodela1 = totalEdges - (neispunjeno1 + neispunjeno2);
        long ispunjenoPodela2 = totalEdges - ispunjenoPodela1;
        
        componentNodes = currentComponentNodes;
        return (ispunjenoPodela1, ispunjenoPodela2);
    }
    
    public static void Main(string[] args)
    {
        var reader = Console.In;
        var writer = Console.Out;
        
        string line1 = reader.ReadLine();
        if (string.IsNullOrEmpty(line1)) return;
        var parts = line1.Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries);
        
        if (parts.Length < 2) return;
        
        int N = int.Parse(parts[0]);
        int M = int.Parse(parts[1]);