import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;

public class Potera {

    static final int INF = Integer.MAX_VALUE;

    // ??????? ?????????? ?? ???-????
    // rGraph[u][v] ???? ???????? ????????? ????? ?? u ?? v
    private static int[][] rGraph;
    private static int V_total; // ?????? ???? ??????? (N + s + t)

    // BFS ?? ??????????? ?????????? ???? (augmenting path)
    private static boolean bfs(int s, int t, int[] parent) {
        boolean[] visited = new boolean[V_total];
        Queue<Integer> queue = new LinkedList<>();
        queue.add(s);
        visited[s] = true;
        parent[s] = -1;

        while (queue.size() != 0) {
            int u = queue.poll();

            for (int v = 0; v < V_total; v++) {
                if (!visited[v] && rGraph[u][v] > 0) {
                    queue.add(v);
                    parent[v] = u;
                    visited[v] = true;
                    if (v == t) return true; // ??? ?? ?????? ????????
                }
            }
        }
        return false;
    }

    // ???????-???? ????????? ?? ?????????? ???
    private static int edmondsKarp(int s, int t) {
        int[] parent = new int[V_total]; // ???? ??? ???????? ?????? BFS-?
        int max_flow = 0;

        // ??? ??????? ????????? ??? ?? s ?? t
        while (bfs(s, t, parent)) {
            // ???? ????????? ?????????? ????????? ?? ?????????? ????
            int path_flow = INF;
            for (int v = t; v != s; v = parent[v]) {
                int u = parent[v];
                path_flow = Math.min(path_flow, rGraph[u][v]);
            }

            // ???????? ?????????? ?????????? ????? ? ???????? ?????
            for (int v = t; v != s; v = parent[v]) {
                int u = parent[v];
                rGraph[u][v] -= path_flow;
                rGraph[v][u] += path_flow;
            }

            max_flow += path_flow;
        }

        return max_flow;
    }

    // ?????? ?????? ???? ???????
    private static void solve() throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        PrintWriter pw = new PrintWriter(System.out);

        // ?????? ????? ???? ???????
        int T = Integer.parseInt(br.readLine());

        for (int t = 0; t < T; t++) {
            StringTokenizer st = new StringTokenizer(br.readLine());
            int N = Integer.parseInt(st.nextToken()); // ???? ???? (???????)
            int M = Integer.parseInt(st.nextToken()); // ???? ??????? (?????)

            // s = N (?????? ??????), t = N + 1 (?????? ??????)
            int s = N;
            int sink = N + 1;
            V_total = N + 2;

            rGraph = new int[V_total][V_total];
            
            // ?????? K_i ?????????
            st = new StringTokenizer(br.readLine());
            int[] K = new int[N];
            long W_plus = 0; // ?????? ????????? ?????? (???? ???? K_i > 0)

            for (int i = 0; i < N; i++) {
                K[i] = Integer.parseInt(st.nextToken());
                
                // ???????? ????? ??/?? s ? t
                if (K[i] > 0) {
                    rGraph[s][i] = K[i];
                    W_plus += K[i];
                } else if (K[i] < 0) {
                    rGraph[i][sink] = -K[i]; // ????????? ?? ????????? ????????
                }
            }

            // ?????? M ??????? (?????????? ?????)
            for (int i = 0; i < M; i++) {
                st = new StringTokenizer(br.readLine());
                int u = Integer.parseInt(st.nextToken());
                int v = Integer.parseInt(st.nextToken());
                
                // ???????? ????? (u, v) ?? ??????????? ???????????
                // ? ??????, ????????? ?????? ????, ???. ??????? ????? ?? ???? ???? ?? W_plus.
                // 2 * W_plus + 1 ?? ??????? ???? ?? ???? ??? ??????? ???? ???? ?? ???????? ??? ?????
                // (??? W_plus ?????????? ?????? ???? ???? ?????????? ??????????).
                rGraph[u][v] = (int)W_plus + 1; 
            }

            // ???????????? ?????????? ???? (??????????? ????)
            int min_cut = edmondsKarp(s, sink);

            // ?????????? ???????? ?????????? ?????
            long max_quality = W_plus - min_cut;

            // ????? ?????????
            if (max_quality > 0) {
                pw.println(max_quality);
            } else {
                pw.println("-1");
            }
        }
        
        pw.flush();
    }

    public static void main(String[] args) throws IOException {
        solve();
    }
}