using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Threading;

public class Potera
{
    private const int INF = int.MaxValue;
    private static int V_total; 
    private static int[,] rGraph;

    private static bool Bfs(int s, int t, int[] parent)
    {
        bool[] visited = new bool[V_total];
        Queue<int> queue = new Queue<int>();
        queue.Enqueue(s);
        visited[s] = true;
        parent[s] = -1;

        while (queue.Count > 0)
        {
            int u = queue.Dequeue();

            for (int v = 0; v < V_total; v++)
            {
                if (!visited[v] && rGraph[u, v] > 0)
                {
                    queue.Enqueue(v);
                    parent[v] = u;
                    visited[v] = true;
                    if (v == t) return true; 
                }
            }
        }
        return false;
    }

    private static int EdmondsKarp(int s, int t)
    {
        int[] parent = new int[V_total]; 
        int max_flow = 0;

        while (Bfs(s, t, parent))
        {
            int path_flow = INF;
            for (int v = t; v != s; v = parent[v])
            {
                int u = parent[v];
                path_flow = Math.Min(path_flow, rGraph[u, v]);
            }

            for (int v = t; v != s; v = parent[v])
            {
                int u = parent[v];
                rGraph[u, v] -= path_flow;
                rGraph[v, u] += path_flow;
            }

            max_flow += path_flow;
        }

        return max_flow;
    }

    public static void Solve()
    {
        using (var reader = new StreamReader(Console.OpenStandardInput()))
        using (var writer = new StreamWriter(Console.OpenStandardOutput()))
        {
            if (!int.TryParse(reader.ReadLine(), out int T)) return;

            for (int t = 0; t < T; t++)
            {
                var line = reader.ReadLine();
                if (line == null) break;

                var tokens = line.Split(' ');
                int N = int.Parse(tokens[0]); 
                int M = int.Parse(tokens[1]); 

                int s = N;
                int sink = N + 1;
                V_total = N + 2;

                rGraph = new int[V_total, V_total];
                
                tokens = reader.ReadLine().Split(' ');
                long W_plus = 0; 

                for (int i = 0; i < N; i++)
                {
                    int Ki = int.Parse(tokens[i]);
                    
                    if (Ki > 0)
                    {
                        rGraph[s, i] = Ki;
                        W_plus += Ki;
                    } 
                    else if (Ki < 0)
                    {
                        rGraph[i, sink] = -Ki; 
                    }
                }

                for (int i = 0; i < M; i++)
                {
                    tokens = reader.ReadLine().Split(' ');
                    int u = int.Parse(tokens[0]);
                    int v = int.Parse(tokens[1]);
                    
                    rGraph[u, v] = (int)W_plus + 1; 
                }

                int min_cut = EdmondsKarp(s, sink);

                long max_quality = W_plus - min_cut;

                if (max_quality > 0)
                {
                    writer.WriteLine(max_quality);
                }
                else
                {
                    writer.WriteLine("-1");
                }
            }
        }
    }

    public static void Main(string[] args)
    {
        new Thread(Solve, 1 << 24).Start(); 
    }
}