#include <bits/stdc++.h>
#define ll long long
#define endl '\n'
#define MAXN 505
#define pii pair <ll, ll>
#define INF 1e18

using namespace std;

struct grana
{
    ll next;
    ll rev;
    ll val;
};

ll N, M;
vector <bool> pos(MAXN);
vector <ll> K(MAXN);
vector < vector <ll> > dp(2, vector <ll> (MAXN));
vector < vector <grana> > graf(MAXN);
vector <ll> dist(MAXN), it(MAXN);

void dodaj_granu(ll X, ll Y, ll val)
{
    grana g1, g2;
    g1.next = Y;
    g1.rev = (ll) graf[Y].size();
    g1.val = val;
    g2.next = X;
    g2.rev = (ll) graf[X].size();
    g2.val = 0LL;
    graf[X].push_back(g1);
    graf[Y].push_back(g2);
}

bool BFS(ll S, ll T)
{
    for(int i = 0; i < N; i++) dist[i] = -1;
    queue <ll> q;
    q.push(S);
    dist[S] = 0;
    while(!q.empty())
    {
        ll node = q.front();
        q.pop();
        for(auto &grana : graf[node])
        {
            ll next = grana.next;
            ll val = grana.val;
            if(dist[next] == -1 && val > 0)
            {
                dist[next] = dist[node] + 1;
                q.push(next);
            }
        }
    }
    cerr << endl;
    for(int i = 0; i < N; i++) cerr << i << ": " << dist[i] << endl;
    return (dist[T] != -1);
}

ll DFS(ll node, ll T, ll flow)
{
    if(node == T) return flow;
    for(ll &i = it[node]; i < (ll) graf[node].size(); i++)
    {
        grana &g = graf[node][i];
        ll next = g.next;
        ll val = g.val;
        ll rev = g.rev;
        if(dist[next] == dist[node] + 1 && val > 0)
        {
            ll aug = DFS(next, T, min(flow, val));
            if(!aug) continue;
            g.val -= aug;
            graf[next][rev].val += aug;
            return aug;
        }
    }
    return 0;
}

ll MAXFLOW(ll S, ll T)
{
    ll flow = 0;
    while(BFS(S, T))
    {
        for(int i = 0; i < N; i++) it[i] = 0;
        while(true)
        {
            ll aug = DFS(S, T, INF);
            if(!aug) break;
            flow += aug;
        }
    }
    return flow;
}

int main()
{
    ios_base::sync_with_stdio(false); cin.tie(0);
    ll t;
    cin >> t;
    while(t--)
    {
        cin >> N >> M;
        for(int i = 0; i < N + 2; i++) {it[i] = 0; dist[i] = -1; graf[i].clear(); K[i] = 0;}
        for(int i = 0; i < N; i++) cin >> K[i];
        ll S = N, T = N + 1, sum = 0;
        for(int i = 0; i < N; i++)
        {
            if(K[i] > 0) {dodaj_granu(S, i, K[i]); sum += K[i];}
            else if(K[i] < 0) dodaj_granu(i, T, -K[i]);
        }
        N += 2;
        for(int i = 0; i < M; i++)
        {
            ll x, y;
            cin >> x >> y;
            dodaj_granu(x, y, INF);
        }
        ll res = sum - MAXFLOW(S, T);
        (res <= 0) ? cout << -1 << endl : cout << res << endl;
    }
    return 0;
}