using System;
using System.Collections.Generic;
using System.Linq;

class Solution
{
    static void Main()
    {
        string all = Console.In.ReadToEnd();
        if (string.IsNullOrWhiteSpace(all)) return;
        var parts = all.Split(new[] { ' ', '\n', '\r', '\t' }, StringSplitOptions.RemoveEmptyEntries);
        long[] tokens = parts.Select(p => long.Parse(p)).ToArray();
        int idx = 0;
        int T = (int)tokens[idx++];

        var outputs = new List<string>();
        for (int tc = 0; tc < T; tc++)
        {
            int N = (int)tokens[idx++];
            int M = (int)tokens[idx++];
            int P = (int)tokens[idx++] - 1;

            long[] K = new long[N];
            for (int i = 0; i < N; i++) K[i] = tokens[idx++];

            var adj = new List<int>[N];
            int[] outdeg = new int[N];
            for (int i = 0; i < N; i++) adj[i] = new List<int>();
            for (int i = 0; i < M; i++)
            {
                int a = (int)tokens[idx++] - 1;
                int b = (int)tokens[idx++] - 1;
                adj[a].Add(b);
                outdeg[a]++;
            }

            var reachable = new bool[N];
            var q = new Queue<int>();
            q.Enqueue(P);
            reachable[P] = true;
            while (q.Count > 0)
            {
                int u = q.Dequeue();
                foreach (var v in adj[u])
                    if (!reachable[v])
                    {
                        reachable[v] = true;
                        q.Enqueue(v);
                    }
            }

            int reachableCount = 0;
            for (int i = 0; i < N; i++) if (reachable[i]) reachableCount++;

            var indeg = new int[N];
            for (int u = 0; u < N; u++) if (reachable[u])
                foreach (var v in adj[u]) if (reachable[v]) indeg[v]++;

            var q2 = new Queue<int>();
            for (int i = 0; i < N; i++) if (reachable[i] && indeg[i] == 0) q2.Enqueue(i);

            var topo = new List<int>();
            while (q2.Count > 0)
            {
                int u = q2.Dequeue();
                topo.Add(u);
                foreach (var v in adj[u]) if (reachable[v])
                {
                    indeg[v]--;
                    if (indeg[v] == 0) q2.Enqueue(v);
                }
            }

            if (topo.Count != reachableCount)
            {
                outputs.Add("-1");
                continue;
            }

            long NEG = long.MinValue / 4;
            long[] dp = Enumerable.Repeat(NEG, N).ToArray();
            dp[P] = K[P];
            foreach (var u in topo)
            {
                if (dp[u] == NEG) continue;
                foreach (var v in adj[u])
                {
                    if (!reachable[v]) continue;
                    long cand = dp[u] + K[v];
                    if (cand > dp[v]) dp[v] = cand;
                }
            }

            long ans = long.MinValue;
            for (int i = 0; i < N; i++)
                if (reachable[i] && outdeg[i] == 0 && dp[i] != NEG)
                    ans = Math.Max(ans, dp[i]);

            outputs.Add(ans == long.MinValue ? "-1" : ans.ToString());
        }

        Console.Write(string.Join("\n", outputs));
    }
}