#include <stdio.h>
#include <stdlib.h>

#define MAXN 500
#define MAXM 1000000

typedef struct {
    int to;
    int next;
} Edge;

Edge edges[MAXM];
int head[MAXN], ecnt;

int n, m;
int K[MAXN];

int dfn[MAXN], low[MAXN], stk[MAXN], in_stk[MAXN];
int scc_id[MAXN], scc_cnt;
int timer, top;

long long scc_sum[MAXN];
int outdeg[MAXN];

void add_edge(int u, int v) {
    edges[ecnt].to = v;
    edges[ecnt].next = head[u];
    head[u] = ecnt++;
}

void tarjan(int u) {
    dfn[u] = low[u] = ++timer;
    stk[top++] = u;
    in_stk[u] = 1;

    for (int e = head[u]; e != -1; e = edges[e].next) {
        int v = edges[e].to;
        if (!dfn[v]) {
            tarjan(v);
            if (low[v] < low[u]) low[u] = low[v];
        } else if (in_stk[v]) {
            if (dfn[v] < low[u]) low[u] = dfn[v];
        }
    }

    if (dfn[u] == low[u]) {
        while (1) {
            int v = stk[--top];
            in_stk[v] = 0;
            scc_id[v] = scc_cnt;
            scc_sum[scc_cnt] += K[v];
            if (v == u) break;
        }
        scc_cnt++;
    }
}

int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &n, &m);

        for (int i = 0; i < n; i++) {
            scanf("%d", &K[i]);
        }

        for (int i = 0; i < n; i++) {
            head[i] = -1;
            dfn[i] = low[i] = in_stk[i] = 0;
        }

        ecnt = timer = top = scc_cnt = 0;

        for (int i = 0; i < m; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge(a, b);
        }

        for (int i = 0; i < n; i++) {
            if (!dfn[i]) tarjan(i);
        }

        for (int i = 0; i < scc_cnt; i++) {
            outdeg[i] = 0;
        }

        for (int u = 0; u < n; u++) {
            for (int e = head[u]; e != -1; e = edges[e].next) {
                int v = edges[e].to;
                if (scc_id[u] != scc_id[v]) {
                    outdeg[scc_id[u]]++;
                }
            }
        }

        long long ans = -1;

        for (int i = 0; i < scc_cnt; i++) {
            if (outdeg[i] == 0 && scc_sum[i] > ans) {
                ans = scc_sum[i];
            }
        }

        if (ans > 0) printf("%lld\n", ans);
        else printf("-1\n");
    }

    return 0;
}