#include <iostream>
#include <stack> // std::push, std::pop, std::front
#include <algorithm> // std::max_element
#include <tuple> // std::tie, std::pair
#include <map>
#include <vector>
#include <string>
#include <sstream> // std::istringstream
#include <iterator> // std::ostream_iterator
#include <limits> // std::numeric_limits

using namespace std;

struct Hodnik {

    int sobaDo;

    Hodnik() {
    }

    Hodnik(int _sobaDo) {
        sobaDo = _sobaDo;
    }
};

int najveciKvalitetDFS(
    const int broj_soba,
    const int broj_hodnika,
    const vector<int>& litara_mleka,
    const map<int, vector<Hodnik>>& hodnici
) {
    vector<bool> posecena(broj_soba, false);
    vector<int> kvalitet(broj_soba);

    int najveci_kvalitet = -1;
    int kvalitet_skupa_soba;
    bool vise_od_jedne_sobe;

    stack<pair<int, int>> stog;

    for (int soba = 0; soba < broj_soba; soba++) {
        if (posecena[soba]) continue;

        fill(kvalitet.begin(), kvalitet.end(), 0);

        kvalitet_skupa_soba = litara_mleka[soba];
        stog.push(make_pair(soba, kvalitet_skupa_soba));

        vise_od_jedne_sobe = false;

        while(!stog.empty()) {
            tie(soba, kvalitet_skupa_soba) = stog.top();
            stog.pop();

            posecena[soba] = true;
            cout << "Posecena soba " << soba << endl;
            kvalitet[soba] = kvalitet_skupa_soba;

            // skup soba S mora da ima najmanje 2 clana (tj. sobe) kako bi se njegov ukupni kvalitet racunao u izlazni rezultat!
            if (vise_od_jedne_sobe && kvalitet_skupa_soba > najveci_kvalitet) {
                najveci_kvalitet = kvalitet_skupa_soba;
            }

            auto it = hodnici.find(soba);
            if (it != hodnici.end()) {
                for (const Hodnik& h : hodnici.at(soba))
                    if (!posecena[h.sobaDo]) {

                        vise_od_jedne_sobe = true;
                        stog.push(make_pair(h.sobaDo, kvalitet[soba] + litara_mleka[h.sobaDo]));
                    }
            }
        }
    }

    return najveci_kvalitet;
}

int main() {
    string red;
    int soba_od, soba_do, celi_broj, i;
    Hodnik hodnik;
    vector<Hodnik> hodnici_sobe;

    int T;
    cin >> T;

    vector<int> N(T), M(T);
    vector<vector<int>> K(T, vector<int>(0));
    vector<map<int, vector<Hodnik>>> hodnici(T, map<int, vector<Hodnik>>({}));

    map<int, vector<Hodnik>> hodnici_1_test;
    vector<Hodnik> hodnici_1_sobe;

    // Ulaz
    for (int t = 0; t < T; t++) {
        cin >> N[t] >> M[t];

        cin.ignore(numeric_limits<streamsize>::max(), '\n');

        getline(cin, red);
        istringstream ss(red);

        while (ss >> celi_broj) {
            K[t].push_back(celi_broj);
        }

        hodnici_1_test.clear();
        for (i = 0; i < M[t]; i++) {
            cin >> soba_od >> soba_do;
            hodnik = Hodnik(soba_do);

            auto it = hodnici_1_test.find(soba_od);
            if (it != hodnici_1_test.end()) {
                hodnici_1_sobe = it->second;
                hodnici_1_sobe.push_back(hodnik);
                hodnici_1_test[soba_od] = hodnici_1_sobe;
            } else {
                hodnici_1_sobe = vector<Hodnik>(0);
                hodnici_1_sobe.push_back(hodnik);
                hodnici_1_test[soba_od] = hodnici_1_sobe;
            }
        }
        hodnici[t] = hodnici_1_test;
    }

    // Izlaz
    int najveci_kvalitet;
    for (int t = 0; t < T; t++) {
        najveci_kvalitet = najveciKvalitetDFS(N[t], M[t], K[t], hodnici[t]);
        if (najveci_kvalitet <= 0) najveci_kvalitet = -1;
        cout << najveci_kvalitet << endl;
    }

    return 0;
}