using System;
using System.Collections.Generic;
using System.Linq;

class EDG{
    public int TOO;
    public int REV;
    public long CAP;
    public EDG(int too, int rev, long cap){
        TOO = too;
        REV = rev;
        CAP = cap;
    }
}

class DIN{
    int NNN;
    List<EDG>[] GRF;
    int[] LVL;
    int[] ITT;

    public DIN(int nnn){
        NNN = nnn;
        GRF = new List<EDG>[nnn];
        for (int i = 0; i < nnn; i++)
            GRF[i] = new List<EDG>();
        LVL = new int[nnn];
        ITT = new int[nnn];
    }

    public void ADD(int aaa, int bbb, long ccc){
        GRF[aaa].Add(new EDG(bbb, GRF[bbb].Count, ccc));
        GRF[bbb].Add(new EDG(aaa, GRF[aaa].Count - 1, 0));
    }

    bool BFS(int sss, int ttt){
        for (int i = 0; i < NNN; i++)
            LVL[i] = -1;
        var QUE = new Queue<int>();
        LVL[sss] = 0;
        QUE.Enqueue(sss);
        while (QUE.Count > 0){
            int VVV = QUE.Dequeue();
            foreach (var EEE in GRF[VVV])
                if (EEE.CAP > 0 && LVL[EEE.TOO] == -1){
                    LVL[EEE.TOO] = LVL[VVV] + 1;
                    QUE.Enqueue(EEE.TOO);
                }
        }
        return LVL[ttt] != -1;
    }

    long DFS(int vvv, int ttt, long fff){
        if (vvv == ttt) return fff;
        for (; ITT[vvv] < GRF[vvv].Count; ITT[vvv]++){
            var EEE = GRF[vvv][ITT[vvv]];
            if (EEE.CAP > 0 && LVL[EEE.TOO] == LVL[vvv] + 1){
                long RET = DFS(EEE.TOO, ttt, Math.Min(fff, EEE.CAP));
                if (RET > 0){
                    EEE.CAP -= RET;
                    GRF[EEE.TOO][EEE.REV].CAP += RET;
                    return RET;
                }
            }
        }
        return 0;
    }

    public long FLW(int sss, int ttt){
        long FLO = 0;
        while (BFS(sss, ttt)){
            for (int i = 0; i < NNN; i++)
                ITT[i] = 0;
            while (true){
                long FFF = DFS(sss, ttt, long.MaxValue);
                if (FFF == 0) break;
                FLO += FFF;
            }
        }
        return FLO;
    }
}

class PRG{
    static void Main(){
        var FSS = new FST();
        int TST = FSS.NXT();
        for (int ttt = 0; ttt < TST; ttt++){
            int NOD = FSS.NXT();
            int EGS = FSS.NXT();
            long[] VAL = new long[NOD];
            long POS = 0;
            for (int i = 0; i < NOD; i++){
                VAL[i] = FSS.LNL();
                if (VAL[i] > 0) POS += VAL[i];
            }

            int SSS = NOD, TTT = NOD + 1;
            var DNK = new DIN(NOD + 2);
            for (int i = 0; i < NOD; i++){
                if (VAL[i] > 0) DNK.ADD(SSS, i, VAL[i]);
                else if (VAL[i] < 0) DNK.ADD(i, TTT, -VAL[i]);
            }
            long INF = (long)4e18;
            for (int i = 0; i < EGS; i++){
                int AAA = FSS.NXT();
                int BBB = FSS.NXT();
                DNK.ADD(AAA, BBB, INF);
            }
            
            long MXF = DNK.FLW(SSS, TTT);
            long RES = POS - MXF;

            if (RES > 0) Console.WriteLine(RES);
            else Console.WriteLine(-1);
        }
    }
}

class FST{
    int IDX = 0;
    string[] DAT = new string[0];
    public FST(){
        string SSS;
        var STR = new System.Text.StringBuilder();
        while (true){
            SSS = Console.ReadLine();
            if (SSS == null) break;
            STR.Append(SSS);
            STR.Append(' ');
        }
        DAT = STR.ToString().Split(new[]{' ', '	', '\n', '\r'}, StringSplitOptions.RemoveEmptyEntries);
    }
    public int NXT(){
        return int.Parse(DAT[IDX++]);
    }
    public long LNL(){
        return long.Parse(DAT[IDX++]);
    }
}