#include <stdio.h>
#include <stdlib.h>

#define MAXN 1000

int color[MAXN+1]; // 0: ?? ??????, 1: ???1, 2: ???2
int adj[MAXN+1][MAXN];
int deg[MAXN+1];

int queue[MAXN+1], front, back;

int main() {
    int N, M;
    scanf("%d %d", &N, &M);

    for(int i=1;i<=N;i++) deg[i]=0;

    int A, B;
    for(int i=0;i<M;i++){
        scanf("%d %d", &A, &B);
        adj[A][deg[A]++] = B;
        adj[B][deg[B]++] = A;
    }

    for(int i=1;i<=N;i++) color[i]=0;

    int possible = 1;
    for(int i=1;i<=N;i++){
        if(color[i]==0){
            // BFS
            front=back=0;
            queue[back++] = i;
            color[i] = 1;
            while(front<back){
                int u = queue[front++];
                for(int j=0;j<deg[u];j++){
                    int v = adj[u][j];
                    if(color[v]==0){
                        color[v] = 3 - color[u]; // ??? ?? 1, ????? 2; ??? ?? 2, ????? 1
                        queue[back++] = v;
                    } else if(color[v]==color[u]){
                        possible = 0;
                        break;
                    }
                }
                if(!possible) break;
            }
        }
        if(!possible) break;
    }

    if(!possible){
        printf("-1\n");
        return 0;
    }

    // ?????? ??????
    int t1=0, t2=0;
    int team1[MAXN], team2[MAXN];
    for(int i=1;i<=N;i++){
        if(color[i]==1) team1[t1++] = i;
        else team2[t2++] = i;
    }

    printf("%d %d\n", t1, t2);
    for(int i=0;i<t1;i++) printf("%d ", team1[i]);
    printf("\n");
    for(int i=0;i<t2;i++) printf("%d ", team2[i]);
    printf("\n");

    return 0;
}