#include <stdio.h>

#define MAXN 1000

int main() {
    int N, M;
    scanf("%d %d", &N, &M);

    int A[MAXN], B[MAXN];
    for(int i = 0; i < M; i++) {
        scanf("%d %d", &A[i], &B[i]);
    }

    int team[MAXN+1] = {0}; 
    int wishes_done = 0;

    for(int i = 0; i < M && wishes_done < M/2; i++) {
        int a = A[i], b = B[i];
        if(team[a]==0 && team[b]==0) {
            team[a] = 1;
            team[b] = 2;
            wishes_done++;
        } else if(team[a]==0 && team[b]!=0) {
            team[a] = (team[b]==1) ? 2 : 1;
            wishes_done++;
        } else if(team[b]==0 && team[a]!=0) {
            team[b] = (team[a]==1) ? 2 : 1;
            wishes_done++;
        } else {
            if(team[a]!=team[b]) {
                wishes_done++;
            }
        }
    }

    for(int i = 1; i <= N; i++) {
        if(team[i]==0) team[i]=1;
    }

    int cnt1=0, cnt2=0;
    for(int i = 1; i <= N; i++) {
        if(team[i]==1) cnt1++;
        else cnt2++;
    }

    printf("%d %d\n", cnt1, cnt2);

    for(int i = 1; i <= N; i++) if(team[i]==1) printf("%d ", i);
    printf("\n");
    for(int i = 1; i <= N; i++) if(team[i]==2) printf("%d ", i);
    printf("\n");

    return 0;
}