#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#define MAXN 505
#define MAXE 2000000
#define INF 1000000000000LL

typedef long long ll;

typedef struct {
    int to;
    ll cap;
    int next;
} Edge;

Edge edges[MAXE];
int head[MAXN], level[MAXN], ptr[MAXN];
int edge_cnt;

void add_edge(int u, int v, ll cap) {
    edges[edge_cnt] = (Edge){v, cap, head[u]};
    head[u] = edge_cnt++;
    edges[edge_cnt] = (Edge){u, 0, head[v]};
    head[v] = edge_cnt++;
}

int bfs(int s, int t) {
    memset(level, -1, sizeof(level));
    int q[MAXN], qh = 0, qt = 0;
    q[qt++] = s;
    level[s] = 0;

    while (qh < qt) {
        int v = q[qh++];
        for (int i = head[v]; i != -1; i = edges[i].next) {
            if (edges[i].cap > 0 && level[edges[i].to] == -1) {
                level[edges[i].to] = level[v] + 1;
                q[qt++] = edges[i].to;
            }
        }
    }
    return level[t] != -1;
}

ll dfs(int v, int t, ll pushed) {
    if (pushed == 0) return 0;
    if (v == t) return pushed;

    for (int *cid = &ptr[v]; *cid != -1; *cid = edges[*cid].next) {
        int id = *cid;
        int to = edges[id].to;
        if (edges[id].cap > 0 && level[to] == level[v] + 1) {
            ll tr = dfs(to, t, pushed < edges[id].cap ? pushed : edges[id].cap);
            if (tr == 0) continue;
            edges[id].cap -= tr;
            edges[id ^ 1].cap += tr;
            return tr;
        }
    }
    return 0;
}

ll maxflow(int s, int t) {
    ll flow = 0;
    while (bfs(s, t)) {
        memcpy(ptr, head, sizeof(head));
        while (1) {
            ll pushed = dfs(s, t, INF);
            if (pushed == 0) break;
            flow += pushed;
        }
    }
    return flow;
}

int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        int N, M;
        scanf("%d %d", &N, &M);

        ll K[MAXN];
        for (int i = 0; i < N; i++) {
            scanf("%lld", &K[i]);
        }

        memset(head, -1, sizeof(head));
        edge_cnt = 0;

        int S = N;
        int Tt = N + 1;

        ll sum_pos = 0;

        for (int i = 0; i < N; i++) {
            if (K[i] > 0) {
                add_edge(S, i, K[i]);
                sum_pos += K[i];
            } else if (K[i] < 0) {
                add_edge(i, Tt, -K[i]);
            }
        }

        for (int i = 0; i < M; i++) {
            int u, v;
            scanf("%d %d", &u, &v);
            add_edge(u, v, INF);
        }

        ll flow = maxflow(S, Tt);
        ll ans = sum_pos - flow;

        if (ans <= 0) printf("-1\n");
        else printf("%lld\n", ans);
    }

    return 0;
}