#include <stdio.h>
#include <stdlib.h>

#define MAXN 505
#define MAXM 500*500+5

int T, N, M;
int K[MAXN];
int g[MAXN][MAXN], gSize[MAXN];
int index[MAXN], lowlink[MAXN], onStack[MAXN], stack[MAXN], idx, top;
int sccId[MAXN], sccSize, sccSum[MAXN], sccOutDeg[MAXN];

void tarjan(int v) {
    index[v] = lowlink[v] = idx++;
    stack[top++] = v;
    onStack[v] = 1;
    for(int i=0;i<gSize[v];i++) {
        int to = g[v][i];
        if(index[to]==-1) {
            tarjan(to);
            if(lowlink[to]<lowlink[v]) lowlink[v]=lowlink[to];
        } else if(onStack[to]) {
            if(index[to]<lowlink[v]) lowlink[v]=index[to];
        }
    }
    if(lowlink[v]==index[v]) {
        int u;
        do {
            u=stack[--top];
            onStack[u]=0;
            sccId[u]=sccSize;
            sccSum[sccSize]+=K[u];
        } while(u!=v);
        sccSize++;
    }
}

int main() {
    scanf("%d",&T);
    while(T--) {
        scanf("%d %d",&N,&M);
        for(int i=0;i<N;i++) scanf("%d",&K[i]);
        for(int i=0;i<N;i++) gSize[i]=0;
        for(int i=0;i<M;i++) {
            int a,b;
            scanf("%d %d",&a,&b);
            g[a][gSize[a]++]=b;
        }
        for(int i=0;i<N;i++) index[i]=-1, onStack[i]=0;
        idx=0; top=0; sccSize=0;
        for(int i=0;i<N;i++) if(index[i]==-1) tarjan(i);
        for(int i=0;i<sccSize;i++) sccOutDeg[i]=0;
        for(int i=0;i<N;i++) {
            for(int j=0;j<gSize[i];j++) {
                int to=g[i][j];
                if(sccId[i]!=sccId[to]) sccOutDeg[sccId[i]]++;
            }
        }
        int ans=-1;
        for(int i=0;i<sccSize;i++) if(sccOutDeg[i]==0 && sccSum[i]>0)
            if(sccSum[i]>ans) ans=sccSum[i];
        printf("%d\n",ans);
    }
    return 0;
}