#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#define MAXN 505
#define MAXM 1000000

int N, M;
long long K[MAXN];

int g[MAXN][MAXN];
int gr[MAXN][MAXN];
int outdeg[MAXN];

int used[MAXN], comp[MAXN];
int order[MAXN], ord_sz;
int comp_cnt;
long long comp_sum[MAXN];

void dfs1(int v) {
    used[v] = 1;
    for (int i = 0; i < N; i++)
        if (g[v][i] && !used[i])
            dfs1(i);
    order[ord_sz++] = v;
}

void dfs2(int v, int c) {
    comp[v] = c;
    comp_sum[c] += K[v];
    for (int i = 0; i < N; i++)
        if (gr[v][i] && comp[i] == -1)
            dfs2(i, c);
}

int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &N, &M);

        for (int i = 0; i < N; i++)
            scanf("%lld", &K[i]);

        memset(g, 0, sizeof(g));
        memset(gr, 0, sizeof(gr));

        for (int i = 0; i < M; i++) {
            int u, v;
            scanf("%d %d", &u, &v);
            g[u][v] = 1;
            gr[v][u] = 1;
        }

        memset(used, 0, sizeof(used));
        ord_sz = 0;

        for (int i = 0; i < N; i++)
            if (!used[i])
                dfs1(i);

        memset(comp, -1, sizeof(comp));
        memset(comp_sum, 0, sizeof(comp_sum));
        comp_cnt = 0;

        for (int i = N - 1; i >= 0; i--) {
            int v = order[i];
            if (comp[v] == -1) {
                dfs2(v, comp_cnt++);
            }
        }

        memset(outdeg, 0, sizeof(outdeg));

        for (int u = 0; u < N; u++) {
            for (int v = 0; v < N; v++) {
                if (g[u][v] && comp[u] != comp[v]) {
                    outdeg[comp[u]] = 1;
                }
            }
        }

        long long ans = 0;
        for (int i = 0; i < comp_cnt; i++) {
            if (outdeg[i] == 0 && comp_sum[i] > 0)
                ans += comp_sum[i];
        }

        if (ans > 0) printf("%lld\n", ans);
        else printf("-1\n");
    }

    return 0;
}