#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct {
    long long prva;
    int druga;
} Grupa;

int Uporedi_Jedan(const void *a, const void *b) {
    long long val_a = *(const long long *)a;
    long long val_b = *(const long long *)b;
    if (val_a < val_b) return -1;
    if (val_a > val_b) return 1;
    return 0;
}

int Uporedi_Dva(const void *a, const void *b) {
    Grupa val_a = *(const Grupa *)a;
    Grupa val_b = *(const Grupa *)b;
    
    if (val_a.prva < val_b.prva) return -1;
    if (val_a.prva > val_b.prva) return 1;
    
    if (val_a.druga < val_b.druga) return -1;
    if (val_a.druga > val_b.druga) return 1;
    
    return 0;
}

long long prebroj_pozdrave_k2(long long *niz, int N) {
    if (N <= 1) return 0;
    qsort(niz, N, sizeof(long long), Uporedi_Jedan);

    long long ukupan_broj_pozdrava = 0;
    long long k;
    
    for (int i = 0; i < N; i++) {
        k = 1;
        while (i + 1 < N && niz[i] == niz[i+1]) {
            k++;
            i++;
        }
        if (k >= 2) {
            ukupan_broj_pozdrava += k * (k - 1);
        }
    }
    return ukupan_broj_pozdrava;
}

long long prebroj_pozdrave_k1(Grupa *niz, int N) {
    if (N <= 1) return 0;
    qsort(niz, N, sizeof(Grupa), Uporedi_Dva);

    long long ukupan_broj_pozdrava = 0;
    long long k;
    
    for (int i = 0; i < N; i++) {
        k = 1;
        
        while (i + 1 < N && 
               niz[i].prva == niz[i+1].prva &&
               niz[i].druga == niz[i+1].druga) {
            k++;
            i++;
        }
        
        if (k >= 2) {
            ukupan_broj_pozdrava += (k * (k - 1)) / 2;
        }
    }
    return ukupan_broj_pozdrava;
}


void resi_zadatak() {
    int N;
    if (scanf("%d", &N) != 1) return;

    long long *u_koordinate = (long long *)malloc(N * sizeof(long long));
    long long *v_koordinate = (long long *)malloc(N * sizeof(long long));
    
    Grupa *y_parnost = (Grupa *)malloc(N * sizeof(Grupa));
    Grupa *x_parnost = (Grupa *)malloc(N * sizeof(Grupa));

    if (u_koordinate == NULL || v_koordinate == NULL || y_parnost == NULL || x_parnost == NULL) {
        if (u_koordinate) free(u_koordinate);
        if (v_koordinate) free(v_koordinate);
        if (y_parnost) free(y_parnost);
        if (x_parnost) free(x_parnost);
        return;
    }

    for (int i = 0; i < N; i++) {
        long long x, y;
        if (scanf("%lld %lld", &x, &y) != 2) {
            free(u_koordinate); free(v_koordinate); free(y_parnost); free(x_parnost);
            return;
        }

        u_koordinate[i] = x + y;
        v_koordinate[i] = x - y;

        y_parnost[i].prva = y;
        y_parnost[i].druga = (int)(x & 1); 

        x_parnost[i].prva = x;
        x_parnost[i].druga = (int)(y & 1);
    }

    long long ukupan_broj_pozdrava = 0;

    ukupan_broj_pozdrava += prebroj_pozdrave_k2(u_koordinate, N);

    ukupan_broj_pozdrava += prebroj_pozdrave_k2(v_koordinate, N);

    ukupan_broj_pozdrava += prebroj_pozdrave_k1(y_parnost, N);

    ukupan_broj_pozdrava += prebroj_pozdrave_k1(x_parnost, N);

    printf("%lld\n", ukupan_broj_pozdrava);

    free(u_koordinate);
    free(v_koordinate);
    free(y_parnost);
    free(x_parnost);
}

int main() {
    resi_zadatak();
    return 0;
}