#include <stdio.h>
#include <stdlib.h>

int Uporedi(const void *a, const void *b) {
    long long val_a = *(const long long *)a;
    long long val_b = *(const long long *)b;
    if (val_a < val_b) return -1;
    if (val_a > val_b) return 1;
    return 0;
}

void resi_zadatak() {
    int N, M;
    if (scanf("%d %d", &N, &M) != 2) return;

    int K = N - 1;

    long long *A = (long long *)malloc(M * sizeof(long long));
    if (A == NULL) return;

    for (int i = 0; i < M; ++i) {
        if (scanf("%lld", &A[i]) != 1) {
            free(A);
            return;
        }
    }

    qsort(A, M, sizeof(long long), Uporedi);
    
    int target_index = M - K;
    
    long long maksimalna_minimax_tezina = A[target_index];

    printf("%lld\n", maksimalna_minimax_tezina);

    free(A);
}

int main() {
    resi_zadatak();
    return 0;
}