#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_N 505
#define INF 2000000001LL

typedef struct Cvor_Lista {
    int v;
    struct Cvor_Lista *sledeci;
} Cvor_Lista;

Cvor_Lista *susedi[MAX_N];
Cvor_Lista *scc_susedi[MAX_N];

int N_soba;
int disc[MAX_N];
int low[MAX_N];
bool onStack[MAX_N];
int stek[MAX_N];
int top_steka = -1;
int tajmer;
int scc_id[MAX_N];
long long scc_v[MAX_N];
int br_scc;
int K[MAX_N];

long long kapacitet[MAX_N][MAX_N]; 
int roditelj[MAX_N]; 

void dodaj_u_listu(Cvor_Lista **glava, int v) {
    Cvor_Lista *novi_cvor = (Cvor_Lista *)malloc(sizeof(Cvor_Lista));
    if (novi_cvor == NULL) return;
    novi_cvor->v = v;
    novi_cvor->sledeci = *glava;
    *glava = novi_cvor;
}

void ocisti_liste(Cvor_Lista **liste, int velicina) {
    for (int i = 0; i < velicina; i++) {
        Cvor_Lista *trenutni = liste[i];
        while (trenutni != NULL) {
            Cvor_Lista *temp = trenutni;
            trenutni = trenutni->sledeci;
            free(temp);
        }
        liste[i] = NULL;
    }
}

int min_c(int a, int b) {
    return (a < b) ? a : b;
}

long long max_ll(long long a, long long b) {
    return (a > b) ? a : b;
}

long long min_ll(long long a, long long b) {
    return (a < b) ? a : b;
}

void stack_push(int u) {
    stek[++top_steka] = u;
    onStack[u] = true;
}

int stack_pop() {
    int u = stek[top_steka--];
    onStack[u] = false;
    return u;
}

void tarjan_scc(int u) {
    disc[u] = low[u] = ++tajmer;
    stack_push(u);

    Cvor_Lista *trenutni = susedi[u];
    while (trenutni != NULL) {
        int v = trenutni->v;
        if (disc[v] == 0) {
            tarjan_scc(v);
            low[u] = min_c(low[u], low[v]);
        } else if (onStack[v]) {
            low[u] = min_c(low[u], disc[v]);
        }
        trenutni = trenutni->sledeci;
    }

    if (low[u] == disc[u]) {
        br_scc++;
        long long trenutna_scc_suma = 0;
        int v;
        do {
            v = stack_pop();
            scc_id[v] = br_scc;
            trenutna_scc_suma += K[v];
        } while (u != v);
        scc_v[br_scc] = trenutna_scc_suma;
    }
}

bool bfs(int S, int T, int N_mreza) {
    memset(roditelj, -1, sizeof(roditelj[0]) * N_mreza);
    roditelj[S] = -2;
    long long queue_kapacitet[MAX_N];
    int queue[MAX_N];
    int front = 0, rear = 0;

    queue[rear++] = S;
    queue_kapacitet[S] = INF;

    while (front != rear) {
        int u = queue[front++];

        for (int v = 0; v < N_mreza; v++) {
            if (roditelj[v] == -1 && kapacitet[u][v] > 0) {
                roditelj[v] = u;
                long long novi_kapacitet = min_ll(queue_kapacitet[u], kapacitet[u][v]);
                queue_kapacitet[v] = novi_kapacitet;
                if (v == T) return true;
                queue[rear++] = v;
            }
        }
    }
    return false;
}

long long edmonds_karp(int S, int T, int N_mreza) {
    long long max_tok = 0;

    while (bfs(S, T, N_mreza)) {
        long long put_tok = INF;
        int v;

        for (v = T; v != S; v = roditelj[v]) {
            put_tok = min_ll(put_tok, kapacitet[roditelj[v]][v]);
        }

        for (v = T; v != S; v = roditelj[v]) {
            kapacitet[roditelj[v]][v] -= put_tok;
            kapacitet[v][roditelj[v]] += put_tok;
        }

        max_tok += put_tok;
    }

    return max_tok;
}

void resi_test_primer() {
    int M_hodnici;
    if (scanf("%d %d", &N_soba, &M_hodnici) != 2) return;

    for (int i = 0; i < N_soba; i++) {
        if (scanf("%d", &K[i]) != 1) return;
    }

    ocisti_liste(susedi, N_soba);
    ocisti_liste(scc_susedi, N_soba + 1);

    for (int i = 0; i < M_hodnici; i++) {
        int u, v;
        if (scanf("%d %d", &u, &v) != 2) return;
        dodaj_u_listu(&susedi[u], v);
    }

    tajmer = 0;
    br_scc = 0;
    top_steka = -1;
    memset(disc, 0, sizeof(disc[0]) * N_soba);
    memset(onStack, 0, sizeof(onStack[0]) * N_soba);
    memset(scc_v, 0, sizeof(scc_v[0]) * (N_soba + 1));

    for (int i = 0; i < N_soba; i++) {
        if (disc[i] == 0) {
            tarjan_scc(i);
        }
    }

    bool dodana_grana[MAX_N][MAX_N];
    memset(dodana_grana, 0, sizeof(dodana_grana));

    for (int u = 0; u < N_soba; u++) {
        Cvor_Lista *trenutni = susedi[u];
        int scc_u = scc_id[u];
        while (trenutni != NULL) {
            int v = trenutni->v;
            int scc_v = scc_id[v];

            if (scc_u != scc_v) {
                if (!dodana_grana[scc_u][scc_v]) {
                    dodaj_u_listu(&scc_susedi[scc_u], scc_v);
                    dodana_grana[scc_u][scc_v] = true;
                }
            }
            trenutni = trenutni->sledeci;
        }
    }
    
    int N_mreza = br_scc + 2;
    int S_izvor = 0;
    int T_potrosac = br_scc + 1;
    
    memset(kapacitet, 0, sizeof(kapacitet