#include <algorithm>
#include <iostream>
#include <vector>

using namespace std;

vector<int> l = {0};
vector<int> s = {0};

int find(int x) {
    if (x == l[x]) return x;
    return l[x] = find(l[x]);
}

bool same(int a, int b) {
    return find(a) == find(b);
}

void unite(int a, int b) {
    a = find(a);
    b = find(b);

    if (s[a] < s[b]) swap(a, b);
    s[a] += s[b];
    l[b] = a;
}

long long kruskal(int n, vector<vector<int>> g) {
    
    l = {0};
    s = {0};
    for (int i = 1; i <= n; i++) l.push_back(i);
    for (int i = 1; i <= n; i++) s.push_back(i);


    sort(g.begin(), g.end(), [](vector<int> a, vector<int> b){return a[2]<b[2];});
    
    long long r = 0;

    for (int i = 0; i < g.size(); i++) {
        if (!same(g[i][0], g[i][1])) {
            unite(g[i][0], g[i][1]);
            r += g[i][2];
        }
    }

    return r;
}

int main(){
    int n,m;
    cin >> n >> m;

    vector<int> a(m);
    for(int i = 0; i < m; i++) cin >> a[i];

    long long sum = 0;
    for (int t = 1; t <= n; t++) {
        vector<pair<int,int>> grane;
        for (int i = 1; i <= t; i++) {
            for (int j = i + 1; j <= t; j++) {
                grane.emplace_back(i,j);
            }
        }

        for (int i = 1; i <= n; i++) {
            for (int j = i + 1; j <= n; j++) {
                if (i > t || j > t) grane.emplace_back(i,j);
            }
        }

        if (grane.size() < m) continue;
        
        vector<vector<int>> graf;
        for (int i = 0; i < m; i++) {
            graf.push_back({grane[i].first, grane[i].second, a[i]});
        }

        long long x = kruskal(n, graf);
        sum = max(sum, x);
    }

    cout << sum << '\n';
}