#include <bits/stdc++.h>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int T;
    cin >> T;
    
    while (T--) {
        int N, M;
        cin >> N >> M;
        
        vector<long long> K(N);
        for (int i = 0; i < N; i++) {
            cin >> K[i];
        }
        
        // Build adjacency list
        vector<vector<int>> adj(N);
        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            adj[a].push_back(b);
            adj[b].push_back(a);
        }
        
        // Find connected components using BFS
        vector<bool> visited(N, false);
        long long minMilk = LLONG_MAX;
        bool foundIsolated = false;
        
        for (int i = 0; i < N; i++) {
            if (!visited[i]) {
                // BFS to find component
                queue<int> q;
                q.push(i);
                visited[i] = true;
                
                long long totalMilk = 0;
                int componentSize = 0;
                vector<int> component;
                
                while (!q.empty()) {
                    int u = q.front();
                    q.pop();
                    
                    totalMilk += K[u];
                    componentSize++;
                    component.push_back(u);
                    
                    for (int v : adj[u]) {
                        if (!visited[v]) {
                            visited[v] = true;
                            q.push(v);
                        }
                    }
                }
                
                // Check if this component is isolated (no outgoing edges)
                bool isIsolated = true;
                for (int u : component) {
                    if (adj[u].size() > 0) {
                        isIsolated = false;
                        break;
                    }
                }
                
                if (isIsolated && totalMilk > 0) {
                    foundIsolated = true;
                    minMilk = min(minMilk, totalMilk);
                }
            }
        }
        
        if (foundIsolated) {
            cout << minMilk << "\n";
        } else {
            cout << "-1\n";
        }
    }
    
    return 0;
}