#include <iostream>
#include <vector>
using namespace std;

vector<int> g[100005], gr[100005];
bool visited[100005];
int comp[100005];
long long K[100005];
long long sumComp[100005];
bool hasOut[100005];
int N, M;

vector<int> order;

void dfs1(int u) {
    visited[u] = true;
    for (int i = 0; i < g[u].size(); i++) {
        int v = g[u][i];
        if (!visited[v]) {
            dfs1(v);
        }
    }
    order.push_back(u);
}

void dfs2(int u, int c) {
    comp[u] = c;
    sumComp[c] += K[u];
    for (int i = 0; i < gr[u].size(); i++) {
        int v = gr[u][i];
        if (comp[v] == -1) {
            dfs2(v, c);
        }
    }
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        cin >> N >> M;

        for (int i = 0; i < N; i++) {
            cin >> K[i];
            g[i].clear();
            gr[i].clear();
            visited[i] = false;
            comp[i] = -1;
        }

        order.clear();

        for (int i = 0; i < M; i++) {
            int A, B;
            cin >> A >> B;
            g[A].push_back(B);
            gr[B].push_back(A);
        }

        // Prvi DFS
        for (int i = 0; i < N; i++) {
            if (!visited[i]) {
                dfs1(i);
            }
        }

        // Drugi DFS
        int cnt = 0;
        for (int i = N - 1; i >= 0; i--) {
            int v = order[i];
            if (comp[v] == -1) {
                sumComp[cnt] = 0;
                dfs2(v, cnt);
                cnt++;
            }
        }

        // Provera izlaza
        for (int i = 0; i < cnt; i++) {
            hasOut[i] = false;
        }

        for (int u = 0; u < N; u++) {
            for (int i = 0; i < g[u].size(); i++) {
                int v = g[u][i];
                if (comp[u] != comp[v]) {
                    hasOut[comp[u]] = true;
                }
            }
        }

        // Odgovor
        long long ans = -1;
        for (int i = 0; i < cnt; i++) {
            if (!hasOut[i] && sumComp[i] > 0) {
                if (ans == -1 || sumComp[i] > ans) {
                    ans = sumComp[i];
                }
            }
        }

        cout << ans << endl;
    }

    return 0;
}