#include <bits/stdc++.h>
using namespace std;

static const long long NEG_INF = -(1LL << 60);

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;

    while (T--) {
        int N, M;
        cin >> N >> M;

        vector<long long> K(N);
        for (int i = 0; i < N; i++) cin >> K[i];

        vector<vector<int>> g(N), gr(N);
        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            g[a].push_back(b);
            gr[b].push_back(a);
        }

        vector<bool> vis(N, false);
        vector<int> order;

        function<void(int)> dfs1 = [&](int u) {
            vis[u] = true;
            for (int v : g[u])
                if (!vis[v]) dfs1(v);
            order.push_back(u);
        };

        for (int i = 0; i < N; i++)
            if (!vis[i]) dfs1(i);

        vector<int> comp(N, -1);
        int scc_cnt = 0;

        function<void(int)> dfs2 = [&](int u) {
            comp[u] = scc_cnt;
            for (int v : gr[u])
                if (comp[v] == -1) dfs2(v);
        };

        for (int i = N - 1; i >= 0; i--) {
            int u = order[i];
            if (comp[u] == -1) {
                dfs2(u);
                scc_cnt++;
            }
        }

        vector<long long> val(scc_cnt, 0);
        for (int i = 0; i < N; i++)
            val[comp[i]] += K[i];

        vector<vector<int>> dag(scc_cnt);
        vector<int> outdeg(scc_cnt, 0);

        for (int u = 0; u < N; u++) {
            for (int v : g[u]) {
                if (comp[u] != comp[v]) {
                    dag[comp[u]].push_back(comp[v]);
                    outdeg[comp[u]]++;
                }
            }
        }

        vector<long long> dp(scc_cnt, NEG_INF);

        function<long long(int)> solve = [&](int u) -> long long {
            if (dp[u] != NEG_INF) return dp[u];
            long long res = val[u];
            for (int v : dag[u]) {
                long long t = solve(v);
                if (t <= 0) {
                    res = NEG_INF;
                    break;
                }
                res += t;
            }
            dp[u] = res;
            return dp[u];
        };

        long long ans = -1;
        for (int i = 0; i < scc_cnt; i++) {
            if (outdeg[i] == 0) {
                long long cur = solve(i);
                if (cur > ans) ans = cur;
            }
        }

        if (ans <= 0) cout << -1 << '\n';
        else cout << ans << '\n';
    }

    return 0;
}