#include <bits/stdc++.h>
using namespace std;

vector<vector<int>> g, gr;
vector<int> order, comp;
vector<bool> vis;

void dfs1(int u) {
    vis[u] = true;
    for (int v : g[u])
        if (!vis[v]) dfs1(v);
    order.push_back(u);
}

void dfs2(int u, int id) {
    comp[u] = id;
    for (int v : gr[u])
        if (comp[v] == -1) dfs2(v, id);
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T;
    cin >> T;
    while (T--) {
        int N, M;
        cin >> N >> M;
        vector<int> K(N);
        for (int i = 0; i < N; i++) cin >> K[i];

        g.assign(N, {});
        gr.assign(N, {});
        for (int i = 0; i < M; i++) {
            int a, b;
            cin >> a >> b;
            g[a].push_back(b);
            gr[b].push_back(a);
        }

        vis.assign(N, false);
        order.clear();
        for (int i = 0; i < N; i++)
            if (!vis[i]) dfs1(i);

        comp.assign(N, -1);
        int scc_cnt = 0;
        for (int i = N-1; i >= 0; i--) {
            int u = order[i];
            if (comp[u] == -1) {
                dfs2(u, scc_cnt++);
            }
        }

        // value SCC
        vector<int> scc_value(scc_cnt, 0);
        for (int i = 0; i < N; i++)
            scc_value[comp[i]] += K[i];

        // build SCC DAG
        vector<vector<int>> dag(scc_cnt);
        for (int u = 0; u < N; u++)
            for (int v : g[u])
                if (comp[u] != comp[v])
                    dag[comp[u]].push_back(comp[v]);

        // remove duplicates in DAG
        for (int i = 0; i < scc_cnt; i++) {
            sort(dag[i].begin(), dag[i].end());
            dag[i].erase(unique(dag[i].begin(), dag[i].end()), dag[i].end());
        }

        long long ans = -1;

        // backtracking po SCC DAG-u
        function<void(int, vector<int>&, long long)> dfs = [&](int u, vector<int>& subset, long long sum) {
            subset.push_back(u);
            sum += scc_value[u];

            // proveri da li je zatvoren
            bool closed = true;
            for (int node : subset) {
                for (int v : dag[node])
                    if (find(subset.begin(), subset.end(), v) == subset.end()) {
                        closed = false;
                        break;
                    }
                if (!closed) break;
            }
            if (closed && sum > 0) ans = max(ans, sum);

            // idi dalje
            for (int v : dag[u])
                if (find(subset.begin(), subset.end(), v) == subset.end())
                    dfs(v, subset, sum);

            subset.pop_back();
        };

        for (int i = 0; i < scc_cnt; i++) {
            vector<int> subset;
            dfs(i, subset, 0);
        }

        cout << ans << "\n";
    }
    return 0;
}