#include <bits/stdc++.h>
using namespace std;

int main() {
    int n, m;
    cin >> n >> m;

    vector<vector<int>> adj(n+1);
    vector<pair<int,int>> edges;
    for(int i=0;i<m;i++){
        int a,b;
        cin >> a >> b;
        adj[a].push_back(b);
        adj[b].push_back(a);
        edges.push_back({a,b});
    }

    vector<int> color(n+1,0);
    queue<int> q;

    for(int i=1;i<=n;i++){
        if(color[i]!=0) continue;
        color[i]=1;
        q.push(i);
        while(!q.empty()){
            int u = q.front(); q.pop();
            for(int v : adj[u]){
                if(color[v]==0){
                    color[v]=3-color[u];
                    q.push(v);
                }
            }
        }
    }
    int ok = 0;
    for(auto [u,v] : edges){
        if(color[u]!=color[v]) ok++;
    }

    if(ok < m/2){
        cout << "-1\n";
        return 0;
    }

    vector<int> team1, team2;
    for(int i=1;i<=n;i++){
        if(color[i]==1) team1.push_back(i);
        else team2.push_back(i);
    }

    cout << team1.size() << " " << team2.size() << "\n";
    for(int x: team1) cout << x << " ";
    cout << "\n";
    for(int x: team2) cout << x << " ";
    cout << "\n";

    return 0;
}