#include <bits/stdc++.h>
using namespace std;
int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N, M;
    cin >> N >> M;
    vector<pair<int,int>> edges(M);
    for (int i = 0; i < M; i++) 
    {
        cin >> edges[i].first >> edges[i].second;
        edges[i].first--;
        edges[i].second--;
    }
    int need = M / 2;
    mt19937 rng(chrono::steady_clock::now().time_since_epoch().count());
    vector<int> team(N), best;
    for (int attempt = 0; attempt < 2000; attempt++) 
    {
        for (int i = 0; i < N; i++)
            team[i] = rng() & 1;
        bool improved = true;
        while (improved) {
            improved = false;
            for (int v = 0; v < N; v++) 
            {
                int delta = 0;
                for (auto &e : edges) 
                {
                    int a = e.first, b = e.second;
                    if (a == v || b == v)
                     {
                        int u = (a == v ? b : a);
                        bool before = (team[v] != team[u]);
                        bool after  = ((team[v] ^ 1) != team[u]);
                        if (after && !before) delta++;
                        if (!after && before) delta--;
                    }
                }
                if (delta > 0) {
                    team[v] ^= 1;
                    improved = true;
                }
            }
        }
        int satisfied = 0;
        for (auto &e : edges)
            if (team[e.first] != team[e.second])
                satisfied++;
        if (satisfied >= need) 
        {
            best = team;
            break;
        }
    }

    if (best.empty()) 
    {
        cout << -1 << "\n";
        return 0;
    }
    vector<int> A, B;
    for (int i = 0; i < N; i++) 
    {
        if (best[i] == 0) A.push_back(i + 1);
        else B.push_back(i + 1);
    }
    cout << A.size() << " " << B.size() << "\n";
    for (int x : A) cout << x << " ";
    cout << "\n";
    for (int x : B) cout << x << " ";
    cout << "\n";
    return 0;
}