#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

int *adj_head;
int *adj_to;
int *adj_next;
int br_grana;

long long *Mleko;     
long long *dp_vrednost; 

void napravi_graf(int N, int M) {
    int max_grane = M;
    
    if (adj_head) free(adj_head);
    if (adj_to) free(adj_to);
    if (adj_next) free(adj_next);

    adj_head = (int*)calloc(N, sizeof(int));
    adj_to = (int*)malloc(max_grane * sizeof(int));
    adj_next = (int*)malloc(max_grane * sizeof(int));
    br_grana = 0;
}

void dodaj_liniju(int u, int v) {
    adj_to[br_grana] = v;
    adj_next[br_grana] = adj_head[u];
    adj_head[u] = br_grana + 1;
    br_grana++;
}

long long vecje(long long a, long long b) {
    return (a > b) ? a : b;
}

long long nadji_max_mleko_dag(int u) {
    if (dp_vrednost[u] != -2LL) {
        return dp_vrednost[u];
    }

    long long trenutni_kv = Mleko[u];
    long long max_od_potomaka = 0;

    for (int i = adj_head[u]; i != 0; i = adj_next[i - 1]) {
        int v = adj_to[i - 1];
        
        long long dete_dp = nadji_max_mleko_dag(v);
    
        max_od_potomaka += vecje(0, dete_dp);
    }

    dp_vrednost[u] = trenutni_kv + max_od_potomaka;
    return dp_vrednost[u];
}

void resi_slucaj() {
    int N, M;
    if (scanf("%d %d", &N, &M) != 2) return;

    Mleko = (long long*)malloc(N * sizeof(long long));
    dp_vrednost = (long long*)malloc(N * sizeof(long long));

    for (int i = 0; i < N; ++i) {
        if (scanf("%lld", &Mleko[i]) != 1) return;
        dp_vrednost[i] = -2LL;
    }
    
    napravi_graf(N, M);

    for (int i = 0; i < M; ++i) {
        int u, v;
        if (scanf("%d %d", &u, &v) != 2) return;
        dodaj_liniju(u, v);
    }
    
    long long max_kvalitet = -1;

    for (int i = 0; i < N; ++i) {
        long long trenutni_dp = nadji_max_mleko_dag(i);
        
        if (trenutni_dp > 0) {
            max_kvalitet = vecje(max_kvalitet, trenutni_dp);
        }
    }

    free(Mleko); 
    free(dp_vrednost);
    
    printf("%lld\n", max_kvalitet);
}

int main() {
    int T;
    if (scanf("%d", &T) != 1) return 0;
    
    adj_head = NULL;
    adj_to = NULL;
    adj_next = NULL;

    while (T--) {
        resi_slucaj();
    }

    if (adj_head) free(adj_head);
    if (adj_to) free(adj_to);
    if (adj_next) free(adj_next);

    return 0;
}