// See https://aka.ms/new-console-template for more information
//Console.WriteLine("Hello, World!");


//using System.Xml.Linq;

class Program
{
    static void Main()
    {
        var line1 = Console.ReadLine().Split();
        int n = int.Parse(line1[0]);
        int m = int.Parse(line1[1]);

        var weights = Console.ReadLine()
            .Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries)
            .Select(long.Parse)
           // .OrderBy(x => x)
            .ToArray();

        //weights = weights.Take(n-1).ToArray();

        //long sum = 0;
        //for (int i = 0; i < weights.Length ; i++)
        //{
        //    sum += weights[i];
        //}

        var sum = SumFirstNOriginal(weights, n);


        Console.WriteLine(sum);
        Console.ReadLine();
    }



    public static long SumFirstNOriginal(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] copy = (int[])array.Clone();
        Array.Sort(copy);

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += copy[i];
        }
        return sum;
    }

    public static long SumFirstNHeap(int[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] heap = new int[n];
        int heapSize = 0;

        foreach (int num in array)
        {
            if (heapSize < n)
            {
                heap[heapSize] = num;
                int current = heapSize;
                heapSize++;

                while (current > 0)
                {
                    int parent = (current - 1) / 2;
                    if (heap[current] <= heap[parent])
                    {
                        int temp = heap[current];
                        heap[current] = heap[parent];
                        heap[parent] = temp;
                        current = parent;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            else if (heapSize > 0 && num < heap[0])
            {
                heap[0] = num;

                int current = 0;
                while (true)
                {
                    int left = current * 2 + 1;
                    int right = current * 2 + 2;
                    int smallest = current;

                    if (left < heapSize && heap[left] < heap[smallest])
                        smallest = left;
                    if (right < heapSize && heap[right] < heap[smallest])
                        smallest = right;

                    if (smallest != current)
                    {
                        int temp = heap[current];
                        heap[current] = heap[smallest];
                        heap[smallest] = temp;
                        current = smallest;
                    }
                    else
                    {
                        break;
                    }
                }
            }
        }

        long sum = 0;
        for (int i = 0; i < heapSize; i++)
        {
            sum += heap[i];
        }

        return sum;
    }

    public static long SumFirstNPartialSort(int[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] copy = (int[])array.Clone();

        int limit = Math.Min(n + 1, copy.Length);
        for (int i = 0; i < limit - 1; i++)
        {
            int minIndex = i;
            for (int j = i + 1; j < limit; j++)
            {
                if (copy[j] < copy[minIndex])
                {
                    minIndex = j;
                }
            }
            if (minIndex != i)
            {
                int temp = copy[i];
                copy[i] = copy[minIndex];
                copy[minIndex] = temp;
            }
        }

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += copy[i];
        }
        return sum;
    }

    public static long SumFirstNQuickSelect(int[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] copy = (int[])array.Clone();

        if (n > 0)
        {
            int left = 0;
            int right = copy.Length - 1;
            int k = n - 1;

            while (left < right)
            {
                int pivot = copy[right];
                int i = left - 1;

                for (int j = left; j < right; j++)
                {
                    if (copy[j] <= pivot)
                    {
                        i++;
                        int temp = copy[i];
                        copy[i] = copy[j];
                        copy[j] = temp;
                    }
                }

                int temp2 = copy[i + 1];
                copy[i + 1] = copy[right];
                copy[right] = temp2;

                int pivotIndex = i + 1;

                if (pivotIndex == k)
                    break;
                else if (pivotIndex > k)
                    right = pivotIndex - 1;
                else
                    left = pivotIndex + 1;
            }
        }

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += copy[i];
        }

        return sum;
    }


}