class Program
{
    static void Main()
    {
        var line1 = Console.ReadLine().Split();
        int n = int.Parse(line1[0]);
        int m = int.Parse(line1[1]);

        var weights = Console.ReadLine()
            .Split(new[] { ' ' }, StringSplitOptions.RemoveEmptyEntries)
            .Select(long.Parse)
            //.OrderBy(x => x)
            .ToArray();

        //weights = weights.Take(n - 1).ToArray();

        //long sum = 0;
        //for (int i = 0; i < weights.Length; i++)
        //{
        //    sum += weights[i];
        //}

        //var sum = SumFirstNOriginal(weights, n-1);
        //var sum = SumLastNHeap(weights, n - 1);
        //var sum  = SumFirstNHeap(weights, n-1) ;
        //var sum = SumFirstNPartialSort(weights, n - 1);
        var sum = SumLastNPartialSort(weights, n - 1);
        //var sum = SumFirstNQuickSelect(weights, n - 1);





        Console.WriteLine(sum);
        Console.ReadLine();
    }



    public static long SumFirstNOriginal(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        //int[] copy = (int[])array.Clone();
        //Array.Sort(copy);

        array = array.OrderByDescending(x => x).ToArray();

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += array[i];
        }
        return sum;
    }

    public static long SumFirstNHeap(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] heap = new int[n];
        int heapSize = 0;

        foreach (int num in array)
        {
            if (heapSize < n)
            {
                heap[heapSize] = num;
                int current = heapSize;
                heapSize++;

                while (current > 0)
                {
                    int parent = (current - 1) / 2;
                    if (heap[current] <= heap[parent])
                    {
                        int temp = heap[current];
                        heap[current] = heap[parent];
                        heap[parent] = temp;
                        current = parent;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            else if (heapSize > 0 && num < heap[0])
            {
                heap[0] = num;

                int current = 0;
                while (true)
                {
                    int left = current * 2 + 1;
                    int right = current * 2 + 2;
                    int smallest = current;

                    if (left < heapSize && heap[left] < heap[smallest])
                        smallest = left;
                    if (right < heapSize && heap[right] < heap[smallest])
                        smallest = right;

                    if (smallest != current)
                    {
                        int temp = heap[current];
                        heap[current] = heap[smallest];
                        heap[smallest] = temp;
                        current = smallest;
                    }
                    else
                    {
                        break;
                    }
                }
            }
        }

        long sum = 0;
        for (int i = 0; i < heapSize; i++)
        {
            sum += heap[i];
        }

        return sum;
    }



    public static long SumLastNHeap(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        int[] heap = new int[n];
        int heapSize = 0;

        foreach (int num in array)
        {
            if (heapSize < n)
            {
                heap[heapSize] = num;
                int current = heapSize;
                heapSize++;

                // Max-heap bubble up (najveci elementi gore)
                while (current > 0)
                {
                    int parent = (current - 1) / 2;
                    if (heap[current] >= heap[parent]) // >= za max-heap
                    {
                        int temp = heap[current];
                        heap[current] = heap[parent];
                        heap[parent] = temp;
                        current = parent;
                    }
                    else
                    {
                        break;
                    }
                }
            }
            else if (heapSize > 0 && num < heap[0]) // < za max-heap
            {
                heap[0] = num;

                int current = 0;
                while (true)
                {
                    int left = current * 2 + 1;
                    int right = current * 2 + 2;
                    int largest = current;

                    if (left < heapSize && heap[left] > heap[largest]) // > za max-heap
                        largest = left;
                    if (right < heapSize && heap[right] > heap[largest]) // > za max-heap
                        largest = right;

                    if (largest != current)
                    {
                        int temp = heap[current];
                        heap[current] = heap[largest];
                        heap[largest] = temp;
                        current = largest;
                    }
                    else
                    {
                        break;
                    }
                }
            }
        }

        long sum = 0;
        for (int i = 0; i < heapSize; i++)
        {
            sum += heap[i];
        }

        return sum;
    }


    public static long SumFirstNPartialSort(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");
        
      

        int limit = Math.Min(n + 1, array.Length);
        for (int i = 0; i < limit - 1; i++)
        {
            int minIndex = i;
            for (int j = i + 1; j < limit; j++)
            {
                if (array[j] < array[minIndex])
                {
                    minIndex = j;
                }
            }
            if (minIndex != i)
            {
                long temp = array[i];
                array[i] = array[minIndex];
                array[minIndex] = temp;
            }
        }

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += array[i];
        }
        return sum;
    }

    public static long SumLastNPartialSort2(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

       // int[] copy = (int[])array.Clone();

        // Selection sort za poslednjih n+1 elemenata - min verzija
        int limit = n + 1;
        for (int i = 0; i < limit - 1; i++)
        {
            int minIndex = i;
            for (int j = i + 1; j < limit; j++)
            {
                if (array[j] < array[minIndex])
                {
                    minIndex = j;
                }
            }
            if (minIndex != i)
            {
                long temp = array[i];
                array[i] = array[minIndex];
                array[minIndex] = temp;
            }
        }

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += array[i];
        }
        return sum;
    }

    public static long SumLastNPartialSort(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

        long[] copy = (long[])array.Clone();

        // Selection sort za poslednjih n elemenata - max verzija
        // Sortiramo poslednjih n elemenata po najvecem
        int startIndex = Math.Max(0, copy.Length - n);
        int limit = copy.Length;

        for (int i = startIndex; i < limit - 1; i++)
        {
            int maxIndex = i;
            for (int j = i + 1; j < limit; j++)
            {
                if (copy[j] > copy[maxIndex]) // > za max
                {
                    maxIndex = j;
                }
            }
            if (maxIndex != i)
            {
                long temp = copy[i];
                copy[i] = copy[maxIndex];
                copy[maxIndex] = temp;
            }
        }

        long sum = 0;
        for (int i = startIndex; i < limit; i++)
        {
            sum += copy[i];
        }
        return sum;
    }



    public static long SumFirstNQuickSelect(long[] array, int n)
    {
        if (n > array.Length || n < 0)
            throw new ArgumentException("n mora biti izmedu 0 i dužine niza");

      

        if (n > 0)
        {
            int left = 0;
            int right = array.Length - 1;
            int k = n - 1;

            while (left < right)
            {
                long pivot = array[right];
                int i = left - 1;

                for (int j = left; j < right; j++)
                {
                    if (array[j] <= pivot)
                    {
                        i++;
                        long temp = array[i];
                        array[i] = array[j];
                        array[j] = temp;
                    }
                }

                long temp2 = array[i + 1];
                array[i + 1] = array[right];
                array[right] = temp2;

                int pivotIndex = i + 1;

                if (pivotIndex == k)
                    break;
                else if (pivotIndex > k)
                    right = pivotIndex - 1;
                else
                    left = pivotIndex + 1;
            }
        }

        long sum = 0;
        for (int i = 0; i < n; i++)
        {
            sum += array[i];
        }

        return sum;
    }


}