using System;
using System.Collections.Generic;

class Program
{
    static void Main()
    {
        var line = Console.ReadLine().Split();
        int n = int.Parse(line[0]);
        int m = int.Parse(line[1]);
        
        List<int>[] adj = new List<int>[n + 1];
        for (int i = 1; i <= n; i++)
            adj[i] = new List<int>();
        
        for (int i = 0; i < m; i++)
        {
            var edge = Console.ReadLine().Split();
            int a = int.Parse(edge[0]);
            int b = int.Parse(edge[1]);
            adj[a].Add(b);
            adj[b].Add(a);
        }
        
        int[] team = new int[n + 1];
        
        int[] sameCount = new int[n + 1];
        int[] diffCount = new int[n + 1];
        
        for (int i = 1; i <= n; i++)
        {
            sameCount[i] = adj[i].Count;
            diffCount[i] = 0;
        }

        bool changed = true;
        while (changed)
        {
            changed = false;
            for (int i = 1; i <= n; i++)
            {
                if (sameCount[i] > diffCount[i])
                {
                    team[i] = 1 - team[i];
                    
                    int temp = sameCount[i];
                    sameCount[i] = diffCount[i];
                    diffCount[i] = temp;
                    
                    foreach (int j in adj[i])
                    {
                        if (team[i] == team[j])
                        {
                            sameCount[j]++;
                            diffCount[j]--;
                        }
                        else
                        {
                            sameCount[j]--;
                            diffCount[j]++;
                        }
                    }
                    changed = true;
                }
            }
        }
        
        List<int> team0 = new List<int>();
        List<int> team1 = new List<int>();
        for (int i = 1; i <= n; i++)
        {
            if (team[i] == 0) team0.Add(i);
            else team1.Add(i);
        }
        
        Console.WriteLine($"{team0.Count} {team1.Count}");
        Console.WriteLine(string.Join(" ", team0));
        Console.WriteLine(string.Join(" ", team1));
    }
}