#include <bits/stdc++.h>
using namespace std;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<vector<int>> g(N+1);
    for(int i = 0; i < M; i++){
        int a, b;
        cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
    }

    // team[i] = 0 or 1
    vector<int> team(N+1, 0);

    bool improved = true;
    while(improved){
        improved = false;
        for(int v = 1; v <= N; v++){
            int same = 0, diff = 0;
            for(int u : g[v]){
                if(team[u] == team[v]) same++;
                else diff++;
            }
            // if switching improves cut
            if(same > diff){
                team[v] ^= 1;
                improved = true;
            }
        }
    }

    // count satisfied wishes
    int satisfied = 0;
    for(int v = 1; v <= N; v++){
        for(int u : g[v]){
            if(u > v && team[u] != team[v])
                satisfied++;
        }
    }

    if(satisfied < M / 2){
        cout << -1 << "\n";
        return 0;
    }

    vector<int> A, B;
    for(int i = 1; i <= N; i++){
        if(team[i] == 0) A.push_back(i);
        else B.push_back(i);
    }

    cout << A.size() << " " << B.size() << "\n";
    for(int x : A) cout << x << " ";
    cout << "\n";
    for(int x : B) cout << x << " ";
    cout << "\n";

    return 0;
}