class DSU:
    def __init__(self, n):
        self.parent = list(range(n))
    def find(self, x):
        if self.parent[x] != x:
            self.parent[x] = self.find(self.parent[x])
        return self.parent[x]
    def union(self, x, y):
        x = self.find(x)
        y = self.find(y)
        if x == y:
            return False
        self.parent[y] = x
        return True

tokovi, putevi = map(int, input().split())
vrednosti = list(map(int, input().split()))

vrednosti.sort(reverse=True)

print(sum(vrednosti[:tokovi-1]))