#include <bits/stdc++.h>
#define ll long long
#define maxn 505
using namespace std;
vector<ll> g[maxn], g2[maxn];
ll k[maxn];
bool vis[maxn];
ll comp[maxn];
vector<ll> red;
ll vel;
vector<ll> mreza[2*maxn];
ll c[2*maxn][2*maxn];
ll nivo[2*maxn], it[2*maxn];
void dfs1(ll i){
    vis[i]=true;
    for (auto next:g[i])
        if (!vis[next]) dfs1(next);
    red.push_back(i);
}
void dfs2(ll i){
    comp[i]=vel;
    for (auto next:g2[i])
        if (comp[next]==-1) dfs2(next);
}
ll n, m;
void reset(){
    for (ll i=0;i<n;i++){
        comp[i]=-1;
        g[i].clear();
        g2[i].clear();
        vis[i]=false;
    }
    red.clear();
    vel=0;
    for (ll i=0;i<2*maxn;i++){
        mreza[i].clear();
        for (ll j=0;j<2*maxn;j++) c[i][j]=0;
    }
}
bool bfs(ll i, ll j){
    fill(nivo, nivo+2*maxn, -1);
    queue <ll> q;
    nivo[i]=0;
    q.push(i);
    while (!q.empty()){
        ll cur=q.front();
        q.pop();
        for (auto next:mreza[cur]){
            if (c[cur][next]>0 && nivo[next]==-1){
                nivo[next]=nivo[cur]+1;
                q.push(next);
            }
        }
    }
    return (nivo[j]!=-1);
}
ll dfs(ll i, ll j, ll l){
    if (i==j) return l;
    for (ll ind=it[i];ind<mreza[i].size();ind++){
        if (c[i][mreza[i][ind]]>0 &&
            nivo[mreza[i][ind]]==nivo[i]+1){
                ll rez=dfs(mreza[i][ind], j,
                           min(l, c[i][mreza[i][ind]]));
                if (rez){
                    c[i][mreza[i][ind]]-=rez;
                    c[mreza[i][ind]][i]+=rez;
                    return rez;
                }
            }
    }
    return 0;
}
ll calc(ll i, ll j){
    ll res=0;
    while (bfs(i, j)){
        fill(it, it+2*maxn, 0);
        while (true){
            ll cur=dfs(i, j, LLONG_MAX);
            if (!cur) break;
            res+=cur;
        }
    }
    return res;
}
int main()
{
    ios_base::sync_with_stdio(false); cin.tie(NULL);
    ll t; cin >> t;
    while (t--){
        cin >> n >> m;
        ll k[n+5];
        for (ll i=0;i<n;i++) cin >> k[i];
        reset();
        for (ll i=0;i<m;i++){
            ll a, b; cin >> a >> b;
            g[a].push_back(b);
            g2[b].push_back(a);
        }
        for (ll i=0;i<n;i++)
            if (!vis[i]) dfs1(i);
        for (ll i=n-1;i>=0;i--){
            if (comp[red[i]]==-1){
                dfs2(red[i]);
                vel++;
            }
        }
        vector<ll> v(vel, 0);
        for (ll i=0;i<n;i++) v[comp[i]]+=k[i];
        ll S=vel, T=vel+1, sum=0;
        for (ll i=0;i<vel;i++){
            if (v[i]>0){
                mreza[S].push_back(i);
                mreza[i].push_back(S);
                c[S][i]+=v[i];
                sum+=v[i];
                continue;
            }
            if (v[i]<0){
                mreza[i].push_back(T);
                mreza[T].push_back(i);
                c[i][T]+=-v[i];
            }
        }
        for (ll i=0;i<n;i++){
            for (auto j:g[i]){
                if (comp[i]!=comp[j]){
                    mreza[comp[i]].push_back(comp[j]);
                    mreza[comp[j]].push_back(comp[i]);
                    c[comp[i]][comp[j]]+=LLONG_MAX;
                }
            }
        }
        ll ans=sum-calc(S, T);
        cout << (ans>0?ans:-1) << '\n';
    }
    return 0;
}
/*

1
5 4
2 -3 -1 3 2
0 1
0 2
2 3
4 2

4




1
4 3
1 1 -1 -1
0 2
0 3
1 3

-1

*/