using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

public class Resenje
{
    private class Ivica
    {
        public int Ka;
        public long Kapacitet;
        public int ObrnutaIvica;
    }

    private static List<Ivica>[] graf;
    private static long maksimalniProtok;
    private static int brojCvorova;

    private static void DodajIvicu(int od, int ka, long kapacitet)
    {
        Ivica napred = new Ivica
        {
            Ka = ka,
            Kapacitet = kapacitet,
            ObrnutaIvica = graf[ka].Count
        };

        Ivica nazad = new Ivica
        {
            Ka = od,
            Kapacitet = 0,
            ObrnutaIvica = graf[od].Count
        };

        graf[od].Add(napred);
        graf[ka].Add(nazad);
    }

    private static long BFS(int izvor, int ponor, long ogranicenje)
    {
        int[] roditelj = new int[brojCvorova];
        int[] indeksIvice = new int[brojCvorova];
        long[] tok = new long[brojCvorova];

        Array.Fill(roditelj, -1);
        Array.Fill(tok, 0);

        Queue<int> red = new Queue<int>();
        red.Enqueue(izvor);
        roditelj[izvor] = izvor;
        tok[izvor] = ogranicenje;

        while (red.Count > 0)
        {
            int trenutno = red.Dequeue();
            if (trenutno == ponor) break;

            for (int i = 0; i < graf[trenutno].Count; i++)
            {
                Ivica ivica = graf[trenutno][i];
                int sledeci = ivica.Ka;

                if (roditelj[sledeci] == -1 && ivica.Kapacitet > 0)
                {
                    roditelj[sledeci] = trenutno;
                    indeksIvice[sledeci] = i;
                    tok[sledeci] = Math.Min(tok[trenutno], ivica.Kapacitet);
                    red.Enqueue(sledeci);
                }
            }
        }

        if (roditelj[ponor] == -1) return 0;

        long protokPuta = tok[ponor];
        int cvor = ponor;

        while (cvor != izvor)
        {
            int prethodni = roditelj[cvor];
            int idx = indeksIvice[cvor];

            graf[prethodni][idx].Kapacitet -= protokPuta;
            graf[cvor][graf[prethodni][idx].ObrnutaIvica].Kapacitet += protokPuta;

            cvor = prethodni;
        }

        return protokPuta;
    }

    private static long EdmondsKarp(int izvor, int ponor, long maksimalno)
    {
        maksimalniProtok = 0;
        long dodatniTok;

        while ((dodatniTok = BFS(izvor, ponor, maksimalno)) > 0)
        {
            maksimalniProtok += dodatniTok;
        }

        return maksimalniProtok;
    }

    public static void Main(string[] args)
    {
        StringBuilder izlaz = new StringBuilder();
        if (!int.TryParse(Console.ReadLine(), out int brojTestova)) return;

        for (int test = 0; test < brojTestova; test++)
        {
            string linija = Console.ReadLine();
            if (string.IsNullOrEmpty(linija)) continue;

            string[] delovi = linija.Split(' ');
            int n = int.Parse(delovi[0]);
            int m = int.Parse(delovi[1]);

            long[] vrednosti = Console.ReadLine()
                .Split(' ')
                .Select(long.Parse)
                .ToArray();

            brojCvorova = n + 2;
            int izvor = 0;
            int ponor = n + 1;

            graf = new List<Ivica>[brojCvorova];
            for (int i = 0; i < brojCvorova; i++)
                graf[i] = new List<Ivica>();

            long sumaPozitivnih = 0;

            for (int i = 0; i < n; i++)
            {
                if (vrednosti[i] > 0)
                {
                    DodajIvicu(izvor, i + 1, vrednosti[i]);
                    sumaPozitivnih += vrednosti[i];
                }
                else
                {
                    DodajIvicu(i + 1, ponor, -vrednosti[i]);
                }
            }

            long beskonacno = sumaPozitivnih + 1;

            for (int i = 0; i < m; i++)
            {
                string[] ivica = Console.ReadLine().Split(' ');
                int u = int.Parse(ivica[0]);
                int v = int.Parse(ivica[1]);

                DodajIvicu(u + 1, v + 1, beskonacno);
            }

            long maxProtok = EdmondsKarp(izvor, ponor, beskonacno);
            long maksimalniKvalitet = sumaPozitivnih - maxProtok;

            izlaz.AppendLine(maksimalniKvalitet > 0
                ? maksimalniKvalitet.ToString()
                : "-1");
        }

        Console.Write(izlaz.ToString());
    }
}