#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, M;
    cin >> N >> M;

    vector<vector<int>> g(N + 1);
    g.reserve(N + 1);

    for (int i = 0; i < M; i++) {
        int a, b;
        cin >> a >> b;
        g[a].push_back(b);
        g[b].push_back(a);
    }

    vector<int> side(N + 1, -1); // 0 ili 1

    for (int v = 1; v <= N; v++) {
        long long c0 = 0, c1 = 0;
        for (int u : g[v]) {
            if (side[u] == -1) continue;   // još nije dodeljen
            if (side[u] == 0) c0++;
            else c1++;
        }
        // ako v u 0 -> zadovoljava veze ka timu 1 (c1)
        // ako v u 1 -> zadovoljava veze ka timu 0 (c0)
        if (c1 >= c0) side[v] = 0;
        else side[v] = 1;
    }

    // (opciono) izracunaj broj zadovoljenih želja (cut size)
    long long cut = 0;
    for (int v = 1; v <= N; v++) {
        for (int u : g[v]) if (u > v) {
            if (side[u] != side[v]) cut++;
        }
    }
    // garantuje cut >= M/2, ali ne štampa se u izlazu

    vector<int> A, B;
    for (int i = 1; i <= N; i++) {
        if (side[i] == 0) A.push_back(i);
        else B.push_back(i);
    }

    cout << A.size() << " " << B.size() << "\n";
    for (int i = 0; i < (int)A.size(); i++) {
        if (i) cout << " ";
        cout << A[i];
    }
    cout << "\n";
    for (int i = 0; i < (int)B.size(); i++) {
        if (i) cout << " ";
        cout << B[i];
    }
    cout << "\n";

    return 0;
}