#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAXN 505
#define MAXM 250000 
#define INF_CAP 1000000000000000LL
typedef struct E1 {
    int to;
    int next;
} E1;

int head1[MAXN], ecnt1;
E1 edges1[MAXM];

void add_edge1(int u, int v) {
    edges1[ecnt1].to = v;
    edges1[ecnt1].next = head1[u];
    head1[u] = ecnt1++;
}
int N, M;
long long Kval[MAXN];

int disc[MAXN], low[MAXN], timerTarjan;
int st[MAXN], topSt, inStack[MAXN];
int comp_id[MAXN], comp_cnt;

void tarjan(int u) {
    disc[u] = low[u] = ++timerTarjan;
    st[topSt++] = u;
    inStack[u] = 1;

    for (int e = head1[u]; e != -1; e = edges1[e].next) {
        int v = edges1[e].to;
        if (!disc[v]) {
            tarjan(v);
            if (low[v] < low[u]) low[u] = low[v];
        } else if (inStack[v] && disc[v] < low[u]) {
            low[u] = disc[v];
        }
    }

    if (low[u] == disc[u]) {
        while (1) {
            int w = st[--topSt];
            inStack[w] = 0;
            comp_id[w] = comp_cnt;
            if (w == u) break;
        }
        comp_cnt++;
    }
}
int chead[MAXN], cecnt;
E1 cedges[MAXM];

void add_cedge(int u, int v) {
    cedges[cecnt].to = v;
    cedges[cecnt].next = chead[u];
    chead[u] = cecnt++;
}
int hasEdge[MAXN][MAXN];
typedef struct E2 {
    int to, next;
    long long cap;
} E2;

#define MAXV 1200
#define MAXE 2000000

E2 edges2[MAXE];
int head2[MAXV], ecnt2;
int S, T, V;

void add_edge2(int u, int v, long long cap) {
    edges2[ecnt2].to = v;
    edges2[ecnt2].cap = cap;
    edges2[ecnt2].next = head2[u];
    head2[u] = ecnt2++;

    edges2[ecnt2].to = u;
    edges2[ecnt2].cap = 0;
    edges2[ecnt2].next = head2[v];
    head2[v] = ecnt2++;
}

int level[MAXV], q[MAXV];
int ptr[MAXV];

int bfs() {
    memset(level, -1, sizeof(int) * V);
    int qs = 0, qe = 0;
    level[S] = 0;
    q[qe++] = S;
    while (qs < qe) {
        int u = q[qs++];
        for (int e = head2[u]; e != -1; e = edges2[e].next) {
            int v = edges2[e].to;
            if (level[v] == -1 && edges2[e].cap > 0) {
                level[v] = level[u] + 1;
                q[qe++] = v;
            }
        }
    }
    return level[T] != -1;
}

long long dfs(int u, long long pushed) {
    if (u == T || pushed == 0) return pushed;
    for (int *pe = &ptr[u]; *pe != -1; *pe = edges2[*pe].next) {
        int e = *pe;
        int v = edges2[e].to;
        if (level[v] == level[u] + 1 && edges2[e].cap > 0) {
            long long tr = dfs(v, pushed < edges2[e].cap ? pushed : edges2[e].cap);
            if (tr > 0) {
                edges2[e].cap -= tr;
                edges2[e ^ 1].cap += tr;
                return tr;
            }
        }
    }
    return 0;
}

long long dinic_maxflow() {
    long long flow = 0;
    while (bfs()) {
        for (int i = 0; i < V; i++) ptr[i] = head2[i];
        long long pushed;
        while ((pushed = dfs(S, INF_CAP)) > 0) {
            flow += pushed;
        }
    }
    return flow;
}

int main() {
    int Ttests;
    if (scanf("%d", &Ttests) != 1) return 0;
    while (Ttests--) {
        if (scanf("%d %d", &N, &M) != 2) return 0;
        for (int i = 0; i < N; i++) scanf("%lld", &Kval[i]);

        ecnt1 = 0;
        for (int i = 0; i < N; i++) head1[i] = -1;
        for (int i = 0; i < M; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge1(a, b);
        }
        memset(disc, 0, sizeof(disc));
        memset(low, 0, sizeof(low));
        memset(inStack, 0, sizeof(inStack));
        topSt = 0; timerTarjan = 0; comp_cnt = 0;
        for (int i = 0; i < N; i++) if (!disc[i]) tarjan(i);
        long long w[MAXN];
        for (int i = 0; i < comp_cnt; i++) w[i] = 0;
        for (int u = 0; u < N; u++) {
            w[comp_id[u]] += Kval[u];
        }
        cecnt = 0;
        for (int i = 0; i < comp_cnt; i++) chead[i] = -1;
        for (int i = 0; i < comp_cnt; i++) {
            for (int j = 0; j < comp_cnt; j++) hasEdge[i][j] = 0;
        }
        for (int u = 0; u < N; u++) {
            int cu = comp_id[u];
            for (int e = head1[u]; e != -1; e = edges1[e].next) {
                int v = edges1[e].to;
                int cv = comp_id[v];
                if (cu != cv && !hasEdge[cu][cv]) {
                    add_cedge(cu, cv);
                    hasEdge[cu][cv] = 1;
                }
            }
        }
        V = comp_cnt + 2;
        S = comp_cnt;
        T = comp_cnt + 1;
        ecnt2 = 0;
        for (int i = 0; i < V; i++) head2[i] = -1;

        long long sum_pos = 0;
        for (int c = 0; c < comp_cnt; c++) {
            if (w[c] > 0) {
                add_edge2(S, c, w[c]);
                sum_pos += w[c];
            } else if (w[c] < 0) {
                add_edge2(c, T, -w[c]);
            }
        }
        for (int u = 0; u < comp_cnt; u++) {
            for (int e = chead[u]; e != -1; e = cedges[e].next) {
                int v = cedges[e].to;
                add_edge2(u, v, INF_CAP);
            }
        }

        long long mincut = dinic_maxflow();
        long long best = sum_pos - mincut;
        if (best <= 0) printf("-1\n");
        else printf("%lld\n", best);
    }
    return 0;
}