using System.Linq;
using System.Xml;

namespace Pejntbol
{
    internal class Program
    {
        public static void UnosPodataka(out int n, out int m, out int[] a, out int[] b)
        {
            int[] input = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            n = input[0];
            m = input[1];

            a = new int[m];
            b = new int[m];

            for (int i = 0; i < m; i++)
            {
                input = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
                a[i] = input[0];
                b[i] = input[1];
            }
        }

        public static void PopunjavanjeTimova(int n, out int[] tim1, out int[] tim2)
        {
            tim1 = new int[(n + 1) / 2];
            tim2 = new int[n / 2];

            for (int i = 0; i < n; i++)
            {
                if(i % 2 == 0) tim1[i / 2] = i + 1;
                else tim2[i / 2] = i + 1;
            }
        }

        public static int ProlazakKrozUpite(int n, int m, int[] tim1, int[] tim2, int[] a, int[] b, out int[] promenaTimaBiOdgovaralaTim1, out int[] promenaTimaBiOdgovaralaTim2)
        {
            promenaTimaBiOdgovaralaTim1 = new int[tim1.Length];
            promenaTimaBiOdgovaralaTim2 = new int[tim2.Length];

            int brojZadovoljenihUpita = 0;

            // Prolazak kroz upite
            for (int i = 0; i < m; i++)
            {
                if (tim1.Contains(a[i]) && tim1.Contains(b[i])) // oba igraca su u istom timu1
                {
                    promenaTimaBiOdgovaralaTim1[Array.IndexOf(tim1, a[i])]++; // -1 zato sto niz pocinje od 0, a igraci od 1 (a[i] je igrac)
                    promenaTimaBiOdgovaralaTim2[Array.IndexOf(tim1, b[i])]++;
                }
                else if(tim2.Contains(a[i]) && tim2.Contains(b[i])) // oba igraca su u istom timu2
                {
                    promenaTimaBiOdgovaralaTim1[Array.IndexOf(tim2, a[i])]++; // -1 zato sto niz pocinje od 0, a igraci od 1 (a[i] je igrac)
                    promenaTimaBiOdgovaralaTim2[Array.IndexOf(tim2, b[i])]++;
                }
                else if(tim1.Contains(a[i]) && tim2.Contains(b[i])) // igraci su u razlicitim timovima
                {
                    promenaTimaBiOdgovaralaTim1[Array.IndexOf(tim1, a[i])]--;
                    promenaTimaBiOdgovaralaTim2[Array.IndexOf(tim2, b[i])]--;
                    brojZadovoljenihUpita++;
                }
                else 
                {
                    promenaTimaBiOdgovaralaTim1[Array.IndexOf(tim2, a[i])]--;
                    promenaTimaBiOdgovaralaTim2[Array.IndexOf(tim1, b[i])]--;
                    brojZadovoljenihUpita++;
                }

            }

            return brojZadovoljenihUpita;
        }

        public static void NalazenjeTimova(int n, int m, int[] a, int[] b, out int[] tim1, out int[] tim2)
        {
            PopunjavanjeTimova(n, out tim1, out tim2);

            while (ProlazakKrozUpite(n, m, tim1, tim2, a, b, out int[] promenaTimaBiOdgovaralaTim1, out int[] promenaTimaBiOdgovaralaTim2) < Math.Floor((double)m / 2))
            {
                // Pronalaženje igraca koji bi promena tima najviše odgovarala
                int maxPromenaTim1 = promenaTimaBiOdgovaralaTim1.Max();
                int maxPromenaTim2 = promenaTimaBiOdgovaralaTim2.Max();
                int igracZaPromenuTim1 = Array.IndexOf(promenaTimaBiOdgovaralaTim1, maxPromenaTim1) + 1; // +1 zato sto niz pocinje od 0, a igraci od 1
                int igracZaPromenuTim2 = Array.IndexOf(promenaTimaBiOdgovaralaTim2, maxPromenaTim2) + 1;
                // Promena timova
                if (maxPromenaTim1 >= maxPromenaTim2)
                {
                    // Promena iz tim1 u tim2
                    tim1 = tim1.Where(x => x != igracZaPromenuTim1).ToArray();
                    tim2 = tim2.Append(igracZaPromenuTim1).ToArray();
                }
                else
                {
                    // Promena iz tim2 u tim1
                    tim2 = tim2.Where(x => x != igracZaPromenuTim2).ToArray();
                    tim1 = tim1.Append(igracZaPromenuTim2).ToArray();
                }
            }
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out int m, out int[] a, out int[] b);

            // Pozivanje metode za popunjavanje timova
            PopunjavanjeTimova(n, out int[] tim1, out int[] tim2);

            Console.WriteLine();
            Console.WriteLine(string.Join(' ', tim1));
            Console.WriteLine(string.Join(' ', tim2));

            ProlazakKrozUpite(n, m, tim1, tim2, a, b, out int[] promenaTimaBiOdgovaralaTim1, out int[] promenaTimaBiOdgovaralaTim2);

            Console.WriteLine();
            Console.WriteLine(string.Join(' ', promenaTimaBiOdgovaralaTim1));
            Console.WriteLine(string.Join(' ', promenaTimaBiOdgovaralaTim2));

            // Nalazenje timova
            NalazenjeTimova(n, m, a, b, out tim1, out tim2);

            Console.WriteLine();
            Console.WriteLine(string.Join(' ', tim1));
            Console.WriteLine(string.Join(' ', tim2));
        }
    }
}