using System.Linq;
using System.Xml;

namespace Pejntbol
{
    internal class Program
    {
        public static void UnosPodataka(out int n, out int m, out int[] a, out int[] b)
        {
            int[] input = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
            n = input[0];
            m = input[1];

            a = new int[m];
            b = new int[m];

            for (int i = 0; i < m; i++)
            {
                input = Array.ConvertAll(Console.ReadLine().Split(' '), int.Parse);
                a[i] = input[0];
                b[i] = input[1];
            }
        }

        public static void PopunjavanjeTimova(int n, out List<int> tim1, out List<int> tim2)
        {
            tim1 = new List<int>((n + 1) / 2);
            tim2 = new List<int>(n / 2);

            for (int i = 0; i < n; i++)
            {
                if(i % 2 == 0) tim1.Add(i + 1);
                else tim2.Add(i + 1);
            }
        }

        public static int ProlazakKrozUpite(int n, int m, List<int> tim1, List<int> tim2, int[] a, int[] b, out int[] promenaTimaBiOdgovaralaTim1, out int[] promenaTimaBiOdgovaralaTim2)
        {
            promenaTimaBiOdgovaralaTim1 = new int[tim1.Count];
            promenaTimaBiOdgovaralaTim2 = new int[tim2.Count];

            int brojZadovoljenihUpita = 0;

            // Prolazak kroz upite
            for (int i = 0; i < m; i++)
            {
                if (tim1.Contains(a[i]) && tim1.Contains(b[i])) // oba igraca su u istom timu1
                {
                    promenaTimaBiOdgovaralaTim1[tim1.IndexOf(a[i])]++; // -1 zato sto niz pocinje od 0, a igraci od 1 (a[i] je igrac)
                    promenaTimaBiOdgovaralaTim1[tim1.IndexOf(b[i])]++;
                }
                else if(tim2.Contains(a[i]) && tim2.Contains(b[i])) // oba igraca su u istom timu2
                {
                    promenaTimaBiOdgovaralaTim2[tim2.IndexOf(a[i])]++; // -1 zato sto niz pocinje od 0, a igraci od 1 (a[i] je igrac)
                    promenaTimaBiOdgovaralaTim2[tim2.IndexOf(b[i])]++;
                }
                else if(tim1.Contains(a[i]) && tim2.Contains(b[i])) // igraci su u razlicitim timovima
                {
                    promenaTimaBiOdgovaralaTim1[tim1.IndexOf(a[i])]--;
                    promenaTimaBiOdgovaralaTim2[tim2.IndexOf(b[i])]--;
                    brojZadovoljenihUpita++;
                }
                else 
                {
                    promenaTimaBiOdgovaralaTim1[tim2.IndexOf(a[i])]--;
                    promenaTimaBiOdgovaralaTim2[tim1.IndexOf(b[i])]--;
                    brojZadovoljenihUpita++;
                }

            }

            return brojZadovoljenihUpita;
        }

        public static bool NalazenjeTimova(int n, int m, int[] a, int[] b, out List<int> tim1, out List<int> tim2)
        {
            PopunjavanjeTimova(n, out tim1, out tim2);

            int brojPrethodnoZadovoljenihUpita = int.MinValue;
            int brojTrenutnoZadovoljenihUpita = ProlazakKrozUpite(n, m, tim1, tim2, a, b, out int[] promenaTimaBiOdgovaralaTim1, out int[] promenaTimaBiOdgovaralaTim2);

            while (brojTrenutnoZadovoljenihUpita < Math.Floor((double)m / 2))
            {
                // Pronalaženje igraca koji bi promena tima najviše odgovarala
                int maxPromenaTim1 = promenaTimaBiOdgovaralaTim1.Max();
                int maxPromenaTim2 = promenaTimaBiOdgovaralaTim2.Max();
                int igracZaPromenuTim1 = Array.IndexOf(promenaTimaBiOdgovaralaTim1, maxPromenaTim1) + 1; // +1 zato sto niz pocinje od 0, a igraci od 1
                int igracZaPromenuTim2 = Array.IndexOf(promenaTimaBiOdgovaralaTim2, maxPromenaTim2) + 1;

                if (maxPromenaTim1 > 0 && maxPromenaTim2 > 0)
                {
                    int pomocna = tim1[tim1.IndexOf(igracZaPromenuTim1)];
                    tim1[tim1.IndexOf(igracZaPromenuTim1)] = tim2[tim2.IndexOf(igracZaPromenuTim2)];
                    tim2[tim2.IndexOf(igracZaPromenuTim2)] = pomocna;
                }
                else if(maxPromenaTim1 > 0)
                {
                    tim2.Add(igracZaPromenuTim1);
                    tim1.Remove(igracZaPromenuTim1);
                }
                else if(maxPromenaTim2 > 0)
                {
                    tim1.Add(igracZaPromenuTim2);
                    tim2.Remove(igracZaPromenuTim2);
                }

                // Provera da li je doslo do poboljsanja
                if (brojPrethodnoZadovoljenihUpita == brojTrenutnoZadovoljenihUpita) return false;

                // Promena timova
                brojPrethodnoZadovoljenihUpita = brojTrenutnoZadovoljenihUpita;
                brojTrenutnoZadovoljenihUpita = ProlazakKrozUpite(n, m, tim1, tim2, a, b, out promenaTimaBiOdgovaralaTim1, out promenaTimaBiOdgovaralaTim2);
            }

            return true;
        }

        static void Main(string[] args)
        {
            // Unos podataka
            UnosPodataka(out int n, out int m, out int[] a, out int[] b);

            // Nalazenje timova
            if (NalazenjeTimova(n, m, a, b, out List<int> tim1, out List<int> tim2))
            {
                Console.WriteLine($"{tim1.Count} {tim2.Count}");
                Console.WriteLine(string.Join(' ', tim1));
                Console.WriteLine(string.Join(' ', tim2));
            }
            else
            {
                Console.WriteLine(-1);
            }     
        }
    }
}