import sys
sys.setrecursionlimit(10**7)

def solve():
    input = sys.stdin.readline
    T = int(input())

    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))

        g = [[] for _ in range(N)]
        gr = [[] for _ in range(N)]

        for _ in range(M):
            a, b = map(int, input().split())
            g[a].append(b)
            gr[b].append(a)

        visited = [False] * N
        order = []

        def dfs1(v):
            visited[v] = True
            for u in g[v]:
                if not visited[u]:
                    dfs1(u)
            order.append(v)

        for i in range(N):
            if not visited[i]:
                dfs1(i)

        comp = [-1] * N
        comp_id = 0

        def dfs2(v):
            stack = [v]
            comp[v] = comp_id
            total = K[v]
            while stack:
                x = stack.pop()
                for u in gr[x]:
                    if comp[u] == -1:
                        comp[u] = comp_id
                        total += K[u]
                        stack.append(u)
            return total

        scc_sum = []
        for v in reversed(order):
            if comp[v] == -1:
                scc_sum.append(dfs2(v))
                comp_id += 1

        C = comp_id 

        outdeg = [0] * C
        for v in range(N):
            for u in g[v]:
                if comp[v] != comp[u]:
                    outdeg[comp[v]] += 1

        ans = 0
        for i in range(C):
            if outdeg[i] == 0 and scc_sum[i] > 0:
                ans += scc_sum[i]

        if ans > 0:
            print(ans)
        else:
            print(-1)


if __name__ == "__main__":
    solve()