import sys
from collections import deque

input = sys.stdin.readline
INF = 10**18


class Dinic:
    def __init__(self, n):
        self.n = n
        self.adj = [[] for _ in range(n)]

    def add_edge(self, u, v, c):
        self.adj[u].append([v, c, len(self.adj[v])])
        self.adj[v].append([u, 0, len(self.adj[u]) - 1])

    def maxflow(self, s, t):
        flow = 0
        while True:
            level = [-1] * self.n
            q = deque([s])
            level[s] = 0

            while q:
                v = q.popleft()
                for u, c, _ in self.adj[v]:
                    if c > 0 and level[u] == -1:
                        level[u] = level[v] + 1
                        q.append(u)

            if level[t] == -1:
                break

            it = [0] * self.n

            def dfs(v, f):
                if v == t:
                    return f
                for i in range(it[v], len(self.adj[v])):
                    it[v] = i
                    u, c, rev = self.adj[v][i]
                    if c > 0 and level[u] == level[v] + 1:
                        pushed = dfs(u, min(f, c))
                        if pushed:
                            self.adj[v][i][1] -= pushed
                            self.adj[u][rev][1] += pushed
                            return pushed
                return 0

            while True:
                pushed = dfs(s, INF)
                if pushed == 0:
                    break
                flow += pushed

        return flow


def solve():
    T = int(input())
    for _ in range(T):
        N, M = map(int, input().split())
        K = list(map(int, input().split()))

        S = N
        Tt = N + 1
        dinic = Dinic(N + 2)

        positive_sum = 0

        for i in range(N):
            if K[i] > 0:
                dinic.add_edge(S, i, K[i])
                positive_sum += K[i]
            else:  
                dinic.add_edge(i, Tt, -K[i])

        for _ in range(M):
            a, b = map(int, input().split())
            dinic.add_edge(a, b, INF)

        min_cut = dinic.maxflow(S, Tt)
        answer = positive_sum - min_cut

        if answer > 0:
            print(answer)
        else:
            print(-1)


if __name__ == "__main__":
    solve()