#include <stdio.h>
#include <stdlib.h>
#include <inttypes.h>
#include <string.h>
#include <math.h>

typedef enum {
    NEODREDJEN=0, TIM_A=1, TIM_B=2
} Tim;



int8_t obojGraf(int16_t n, int16_t graf[n][n], Tim* timovi, int16_t dozvoljeneGreske, int16_t cvor) {
    if(cvor==n) return 1;
    int16_t susediTimA=0, susediTimB=0;
    for(int16_t i=0;i<n;i++) {
        if(graf[cvor][i]>=1) {
            if(timovi[i]==TIM_A) susediTimA+=graf[cvor][i];
            else if(timovi[i]==TIM_B) susediTimB+=graf[cvor][i];
        }
    }
    Tim izbor=(susediTimA<=susediTimB) ? TIM_A : TIM_B;
    if(izbor==TIM_A) {
        if(dozvoljeneGreske>susediTimA){
            timovi[cvor]=TIM_A;
            if(obojGraf(n, graf, timovi, dozvoljeneGreske-susediTimA, cvor+1)==-1) {
                timovi[cvor]=NEODREDJEN;
                return -1;
            }
            else return 1; 
        }
        if(dozvoljeneGreske>susediTimB){
            timovi[cvor]=TIM_B;
            if(obojGraf(n, graf, timovi, dozvoljeneGreske-susediTimB, cvor+1)==-1) {
                timovi[cvor]=NEODREDJEN;
                return -1;
            }
            else return 1;
        }
    }
    else {
        if(dozvoljeneGreske>susediTimB){
            timovi[cvor]=TIM_B;
            if(obojGraf(n, graf, timovi, dozvoljeneGreske-susediTimB, cvor+1)==-1) {
                timovi[cvor]=NEODREDJEN;
                return -1;
            }
            else return 1;
        }
        if(dozvoljeneGreske>susediTimA){
            timovi[cvor]=TIM_A;
            if(obojGraf(n, graf, timovi, dozvoljeneGreske-susediTimA, cvor+1)==-1) {
                timovi[cvor]=NEODREDJEN;
                return -1;
            }
            else return 1; 
        }
    }
    
    return -1;
}

int main() {
    int n, m;
    scanf("%d %d", &n, &m);
    int16_t graf[n][n];
    Tim timovi[n];
    memset((void*) graf, 0, n*n*sizeof(int16_t));
    memset((void*) timovi, 0, n*sizeof(Tim));
    for(int16_t i=0;i<m;i++) {
        int clan, zelja;
        scanf("%d %d", &clan, &zelja);
        clan--; zelja--;
        graf[clan][zelja]+=1;
        graf[zelja][clan]+=1;
    }
    //int16_t dozvoljeneGreske=(m&1) ? m/2+1 : m/2;
    int8_t ret=obojGraf(n, graf, timovi, m/2, 0);
    if(ret!=-1) {
        uint16_t counterTimA=0, counterTimB=0;
        for(int16_t i=0;i<n;i++) {
            if(timovi[i]==TIM_A) counterTimA++;
            if(timovi[i]==TIM_B) counterTimB++;
        }
        printf("%" PRIu16 " %" PRIu16 "\n", counterTimA, counterTimB);
        for(int16_t i=0;i<n;i++) {
            if(timovi[i]==TIM_A) printf("%" PRId16 " ", i+1);
        }
        printf("\n");
        for(int16_t i=0;i<n;i++) {
            if(timovi[i]==TIM_B) printf("%" PRId16 " ", i+1);
        }
    }
    else {
        printf("%d", -1);
    }
    return 0;
}