#include <bits/stdc++.h>

#define int int64_t

const int N = 2e5 + 5;

const int S = 450;

int inf = 1e18;

// https://pastebin.com/iJhP7yJw

class MaxFlow{
private:
  struct Edge{
    int to;
    int rev;
    int flow;
    int cap;
  };
  int n;
  std::vector<std::vector<Edge>> g;
  std::vector<int> level, rem;
  int source;
  int sink;
public:
  MaxFlow(int n_) {
    n = n_;
    source = 0;
    sink = n - 1;

    g.resize(n);
    level.resize(n);
    rem.resize(n);
  }
  void addEdge(int x, int y, int cap) {
    g[x].push_back({y, (int)g[y].size(), 0, cap});
    g[y].push_back({x, (int)g[x].size() - 1, 0, 0});
  }
  void setSourceSink(int _source, int _sink) {
    source = _source;
    sink = _sink;
  }
  bool BFS() {
    for(int i = 0; i < n; i++)
      level[i] = -1;
    std::queue<int> q;
    level[source] = 0;
    q.push(source);
    while(0 < q.size()) {
      int node = q.front();
      q.pop();
      for(int h = 0; h < g[node].size(); h++) {
        Edge e = g[node][h];
        if(e.flow < e.cap && level[e.to] == -1) {
          level[e.to] = level[node] + 1;
          q.push(e.to);
        }
      }
    }
    return 0 <= level[sink];
  }
  int DFS(int node, int delta) {
    if(node == sink)
      return delta;
    else {
      for(int &h = rem[node]; h < g[node].size(); h++) {
        Edge &e = g[node][h];
        if(e.flow < e.cap && level[node] + 1 == level[e.to]) {
          int deltaflow = DFS(e.to, std::min(delta, e.cap - e.flow));
          if(0 < deltaflow) {
            e.flow += deltaflow;
            g[e.to][e.rev].flow -= deltaflow;
            return deltaflow;
          }
        }
      }
      return 0;
    }
  }
  int64_t maxflow() {
    int64_t result = 0, delta = 0;
    while(BFS()) {
      for(int i = 0; i < n; i++)
        rem[i] = 0;
      delta = 0;
      do {
        result += delta;
        delta = DFS(source, inf);
      } while(0 < delta);
    }
    return result;
  }
};

signed main() {
  int tt;
  std::cin >> tt;
  for(int t = 1; t <= tt; t++) {
    int n, m;
    std::cin >> n >> m;
    std::vector<int> c(n);
    int sum = 0;
    int sorc = n;
    int sin = n + 1;
    MaxFlow graph(3 + n);
    graph.setSourceSink(sorc, sin);
    for(int i = 0; i < n; i++) {
      std::cin >> c[i];
      if(c[i] < 0) {
        graph.addEdge(i, sin, -c[i]);
      }
      else {
        graph.addEdge(sorc, i, c[i]);
        sum += c[i];

      }
    }
    for(int i = 0; i < m; i++) {
      int u, v;
      std::cin >> u >> v;
      graph.addEdge(u, v, inf);
    }
    int ans = sum - graph.maxflow();
    std::cout << (ans <= 0 ? - 1 : ans) << "\n";
  }
}