#include <stdio.h>
#include <string.h>
#include <limits.h>
#define MAXN 100005
#define MAXM 300005
#define INF  ((long long)1e18)
int N, M;
int g[MAXN][2];
int head[MAXN], nxt[MAXM], to[MAXM], ecnt;
int stack[MAXN], top;
int dfn[MAXN], low[MAXN], onstack[MAXN], comp[MAXN];
int timer, comp_cnt;
long long K[MAXN], comp_w[MAXN];
typedef struct {
    int v, nxt;
    long long cap;
} Edge;
Edge E[MAXM * 4];
int H[MAXN], cur[MAXN], level[MAXN], ec;
int SRC, SNK;
void add_edge(int u, int v) {
    to[ecnt] = v;
    nxt[ecnt] = head[u];
    head[u] = ecnt++;
}
void tarjan(int u) {
    dfn[u] = low[u] = ++timer;
    stack[++top] = u;
    onstack[u] = 1;
    for (int i = head[u]; i != -1; i = nxt[i]) {
        int v = to[i];
        if (!dfn[v]) {
            tarjan(v);
            if (low[v] < low[u]) low[u] = low[v];
        } else if (onstack[v] && dfn[v] < low[u]) {
            low[u] = dfn[v];
        }
    }
    if (dfn[u] == low[u]) {
        comp_cnt++;
        int v;
        do {
            v = stack[top--];
            onstack[v] = 0;
            comp[v] = comp_cnt;
            comp_w[comp_cnt] += K[v];
        } while (v != u);
    }
}
void add_flow_edge(int u, int v, long long c) {
    E[ec] = (Edge){v, H[u], c}; H[u] = ec++;
    E[ec] = (Edge){u, H[v], 0}; H[v] = ec++;
}
int bfs() {
    int q[MAXN], l = 0, r = 0;
    memset(level, -1, sizeof(level));
    level[SRC] = 0;
    q[r++] = SRC;
    while (l < r) {
        int u = q[l++];
        for (int i = H[u]; i != -1; i = E[i].nxt) {
            int v = E[i].v;
            if (level[v] < 0 && E[i].cap > 0) {
                level[v] = level[u] + 1;
                q[r++] = v;
            }
        }
    }
    return level[SNK] >= 0;
}
long long dfs(int u, long long f) {
    if (!f || u == SNK) return f;
    for (int *i = &cur[u]; *i != -1; *i = E[*i].nxt) {
        int id = *i, v = E[id].v;
        if (E[id].cap > 0 && level[v] == level[u] + 1) {
            long long pushed = dfs(v, f < E[id].cap ? f : E[id].cap);
            if (pushed) {
                E[id].cap -= pushed;
                E[id ^ 1].cap += pushed;
                return pushed;
            }
        }
    }
    return 0;
}
long long maxflow() {
    long long flow = 0;
    while (bfs()) {
        memcpy(cur, H, sizeof(H));
        long long f;
        while ((f = dfs(SRC, INF))) flow += f;
    }
    return flow;
}
int main() {
    int T;
    scanf("%d", &T);

    while (T--) {
        scanf("%d %d", &N, &M);

        for (int i = 1; i <= N; i++) scanf("%lld", &K[i]);

        memset(head, -1, sizeof(head));
        ecnt = 0;

        for (int i = 0; i < M; i++) {
            int a, b;
            scanf("%d %d", &a, &b);
            add_edge(a, b);
        }
        memset(dfn, 0, sizeof(dfn));
        memset(low, 0, sizeof(low));
        memset(onstack, 0, sizeof(onstack));
        memset(comp_w, 0, sizeof(comp_w));
        timer = top = comp_cnt = 0;

        for (int i = 1; i <= N; i++)
            if (!dfn[i]) tarjan(i);
        memset(H, -1, sizeof(H));
        ec = 0;
        SRC = 0;
        SNK = comp_cnt + 1;

        long long pos_sum = 0;

        for (int i = 1; i <= comp_cnt; i++) {
            if (comp_w[i] > 0) {
                add_flow_edge(SRC, i, comp_w[i]);
                pos_sum += comp_w[i];
            } else if (comp_w[i] < 0) {
                add_flow_edge(i, SNK, -comp_w[i]);
            }
        }
        for (int u = 1; u <= N; u++) {
            for (int i = head[u]; i != -1; i = nxt[i]) {
                int v = to[i];
                if (comp[u] != comp[v]) {
                    add_flow_edge(comp[u], comp[v], INF);
                }
            }
        }
        long long flow = maxflow();
        long long ans = pos_sum - flow;
        if (ans > 0) printf("%lld\n", ans);
        else printf("-1\n");
    }
    return 0;
}