#include <bits/stdc++.h>

using namespace std;

#define fi first
#define se second

class Graf
{
    int N;
    list<int> *l;

    public:
        Graf(int n)
        {
            N=n;
            l=new list<int>[N];
        }

    void addEdge(int i,int j,bool dir)
    {
        l[i].push_back(j);
        if(dir==false)l[j].push_back(i);
    }

    void print()
    {
        for(int i=0; i<N; i++)
        {
            for(auto node:l[i])
            {
                cout << node << " " ;
            }
            cout << endl;
        }
    }

    void dfsH(int a,vector<bool> *visited,int t1,vector<int> *v1,vector<int> *v2)
    {
        if((*visited)[a]==true)return;

        (*visited)[a]=true;
        if(t1==1)(*v1).push_back(a);
        else if(t1==-1)(*v2).push_back(a);

        for(auto br:l[a])
        {
            if(!(*visited)[br])dfsH(br,visited,t1*(-1),v1,v2);
        }
        return;
    }

    void dfs(int src,vector<bool> *visited,vector<int> *v1,vector<int> *v2)
    {
        dfsH(src,visited,1,v1,v2);
    }
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n,m;
    cin >> n >> m;

    Graf a(n+1);
    vector<int> v1,v2;
    vector<bool> visited(n);
    for(int i=0; i<n;i++)visited[i]=false;

    for(int i=0; i<m; i++)
    {
        int x,y;
        cin >> x >> y;
        a.addEdge(x,y,true);
    }

    for(int i=1;i<n; i++)
    {
        if(visited[i]==false)a.dfs(i,&visited,&v1,&v2);
    }


    cout << v1.size() << " " << v2.size() << endl;
    for(auto i:v1)cout << i << " ";
    cout << endl;
    for(auto i:v2)cout << i << " ";
    cout << endl;

    return 0;
}