try:
    line = input().split()
    if not line:
        n, m = 0, 0
    else:
        n = int(line[0])
        m = int(line[1])
except EOFError:
    n, m = 0, 0

adj = [[] for _ in range(n + 1)]

for _ in range(m):
    try:
        edge = input().split()
        if not edge:
            break
        u = int(edge[0])
        v = int(edge[1])
        adj[u].append(v)
        adj[v].append(u)
    except EOFError:
        break

groups = [-1] * (n + 1)

for i in range(1, n + 1):
    c0 = 0
    c1 = 0
    for neighbor in adj[i]:
        if groups[neighbor] != -1:
            if groups[neighbor] == 0:
                c0 += 1
            else:
                c1 += 1
    
    if c0 <= c1:
        groups[i] = 0
    else:
        groups[i] = 1

team1 = []
team2 = []

for i in range(1, n + 1):
    if groups[i] == 0:
        team1.append(i)
    else:
        team2.append(i)

print(len(team1), len(team2))
print(*(team1))
print(*(team2))